/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientSSLOptionsConverter;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class ClientSSLOptions
extends SSLOptions {
    public static final String DEFAULT_HOSTNAME_VERIFICATION_ALGORITHM = null;
    public static final boolean DEFAULT_TRUST_ALL = false;
    private String hostnameVerificationAlgorithm;
    private boolean trustAll;

    public ClientSSLOptions() {
    }

    public ClientSSLOptions(ClientSSLOptions other) {
        super(other);
        this.hostnameVerificationAlgorithm = other.getHostnameVerificationAlgorithm();
        this.trustAll = other.trustAll;
    }

    public ClientSSLOptions(JsonObject json) {
        super(json);
        ClientSSLOptionsConverter.fromJson(json, this);
    }

    @Override
    protected void init() {
        super.init();
        this.hostnameVerificationAlgorithm = DEFAULT_HOSTNAME_VERIFICATION_ALGORITHM;
        this.trustAll = false;
    }

    @Override
    public ClientSSLOptions copy() {
        return new ClientSSLOptions(this);
    }

    public String getHostnameVerificationAlgorithm() {
        return this.hostnameVerificationAlgorithm;
    }

    public ClientSSLOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        this.hostnameVerificationAlgorithm = hostnameVerificationAlgorithm;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public ClientSSLOptions setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    @Override
    public ClientSSLOptions setKeyCertOptions(KeyCertOptions options) {
        return (ClientSSLOptions)super.setKeyCertOptions(options);
    }

    @Override
    public ClientSSLOptions setTrustOptions(TrustOptions options) {
        return (ClientSSLOptions)super.setTrustOptions(options);
    }

    @Override
    public ClientSSLOptions setUseAlpn(boolean useAlpn) {
        return (ClientSSLOptions)super.setUseAlpn(useAlpn);
    }

    @Override
    public ClientSSLOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        return (ClientSSLOptions)super.setSslHandshakeTimeout(sslHandshakeTimeout);
    }

    @Override
    public ClientSSLOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        return (ClientSSLOptions)super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
    }

    @Override
    public ClientSSLOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (ClientSSLOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    @Override
    public ClientSSLOptions setApplicationLayerProtocols(List<String> protocols) {
        return (ClientSSLOptions)super.setApplicationLayerProtocols(protocols);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ClientSSLOptionsConverter.toJson(this, json);
        return json;
    }
}

