/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrafficShapingOptions;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TrafficShapingOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, TrafficShapingOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "inboundGlobalBandwidth": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setInboundGlobalBandwidth(((Number)member.getValue()).longValue());
                    break;
                }
                case "outboundGlobalBandwidth": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setOutboundGlobalBandwidth(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxDelayToWait": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxDelayToWait(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxDelayToWaitUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMaxDelayToWaitUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "checkIntervalForStats": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setCheckIntervalForStats(((Number)member.getValue()).longValue());
                    break;
                }
                case "checkIntervalForStatsTimeUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCheckIntervalForStatsTimeUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "peakOutboundGlobalBandwidth": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPeakOutboundGlobalBandwidth(((Number)member.getValue()).longValue());
                    break;
                }
            }
        }
    }

    static void toJson(TrafficShapingOptions obj, JsonObject json) {
        TrafficShapingOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(TrafficShapingOptions obj, Map<String, Object> json) {
        json.put("inboundGlobalBandwidth", obj.getInboundGlobalBandwidth());
        json.put("outboundGlobalBandwidth", obj.getOutboundGlobalBandwidth());
        json.put("maxDelayToWait", obj.getMaxDelayToWait());
        json.put("checkIntervalForStats", obj.getCheckIntervalForStats());
        if (obj.getCheckIntervalForStatsTimeUnit() != null) {
            json.put("checkIntervalForStatsTimeUnit", obj.getCheckIntervalForStatsTimeUnit().name());
        }
        json.put("peakOutboundGlobalBandwidth", obj.getPeakOutboundGlobalBandwidth());
        if (obj.getMaxDelayToWaitTimeUnit() != null) {
            json.put("maxDelayToWaitTimeUnit", obj.getMaxDelayToWaitTimeUnit().name());
        }
    }
}

