/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.codec.json;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.impl.codec.json.AbstractJsonCodec;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class JsonObjectCodec
extends AbstractJsonCodec<JsonObject, JsonArray>
implements CollectibleCodec<JsonObject> {
    public static final String ID_FIELD = "_id";
    public static final String DATE_FIELD = "$date";
    public static final String BINARY_FIELD = "$binary";
    public static final String TYPE_FIELD = "$type";
    public static final String OID_FIELD = "$oid";
    public static final String LONG_FIELD = "$numberLong";
    public static final String DECIMAL_FIELD = "$numberDecimal";
    public static final String TIMESTAMP_FIELD = "$timestamp";
    public static final String TIMESTAMP_TIME_FIELD = "t";
    public static final String TIMESTAMP_INCREMENT_FIELD = "i";
    private boolean useObjectId = false;

    public JsonObjectCodec(JsonObject config) {
        this.useObjectId = config.getBoolean("useObjectId", Boolean.valueOf(false));
    }

    public JsonObject generateIdIfAbsentFromDocument(JsonObject json) {
        if (!this.documentHasId(json)) {
            String value = JsonObjectCodec.generateHexObjectId();
            if (this.useObjectId) {
                json.put(ID_FIELD, (Object)new JsonObject().put(OID_FIELD, (Object)value));
            } else {
                json.put(ID_FIELD, (Object)value);
            }
        }
        return json;
    }

    public static String generateHexObjectId() {
        ObjectId id = new ObjectId();
        return id.toHexString();
    }

    public boolean documentHasId(JsonObject json) {
        return json.containsKey(ID_FIELD);
    }

    public BsonValue getDocumentId(JsonObject json) {
        if (!this.documentHasId(json)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id = json.getValue(ID_FIELD);
        if (id instanceof String) {
            return new BsonString((String)id);
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(idHoldingDocument);
        writer.writeStartDocument();
        writer.writeName(ID_FIELD);
        this.writeValue((BsonWriter)writer, null, id, EncoderContext.builder().build());
        writer.writeEndDocument();
        return idHoldingDocument.get((Object)ID_FIELD);
    }

    public Class<JsonObject> getEncoderClass() {
        return JsonObject.class;
    }

    @Override
    protected boolean isObjectIdInstance(Object instance) {
        return instance instanceof JsonObject && ((JsonObject)instance).containsKey(OID_FIELD);
    }

    @Override
    protected void beforeFields(JsonObject object, BiConsumer<String, Object> objectConsumer) {
        if (object.containsKey(ID_FIELD)) {
            objectConsumer.accept(ID_FIELD, object.getValue(ID_FIELD));
        }
    }

    @Override
    protected JsonObject newObject() {
        return new JsonObject();
    }

    @Override
    protected void add(JsonObject object, String name, Object value) {
        object.put(name, value);
    }

    @Override
    protected boolean isObjectInstance(Object instance) {
        return instance instanceof JsonObject;
    }

    @Override
    protected void forEach(JsonObject object, BiConsumer<String, Object> objectConsumer) {
        object.forEach(entry -> objectConsumer.accept((String)entry.getKey(), entry.getValue()));
    }

    @Override
    protected JsonArray newArray() {
        return new JsonArray();
    }

    @Override
    protected void add(JsonArray array, Object value) {
        if (value != null) {
            array.add(value);
        } else {
            array.addNull();
        }
    }

    @Override
    protected boolean isArrayInstance(Object instance) {
        return instance instanceof JsonArray;
    }

    @Override
    protected void forEach(JsonArray array, Consumer<Object> arrayConsumer) {
        array.forEach(arrayConsumer);
    }

    @Override
    protected BsonType getBsonType(Object value) {
        BsonType type = super.getBsonType(value);
        if (type == BsonType.DOCUMENT) {
            JsonObject obj = (JsonObject)value;
            if (obj.containsKey(DATE_FIELD)) {
                return BsonType.DATE_TIME;
            }
            if (obj.containsKey(OID_FIELD)) {
                return BsonType.OBJECT_ID;
            }
            if (obj.containsKey(BINARY_FIELD)) {
                return BsonType.BINARY;
            }
            if (obj.containsKey(TIMESTAMP_FIELD)) {
                return BsonType.TIMESTAMP;
            }
            if (obj.containsKey(LONG_FIELD)) {
                return BsonType.INT64;
            }
            if (obj.containsKey(DECIMAL_FIELD)) {
                return BsonType.DECIMAL128;
            }
        }
        return type;
    }

    @Override
    protected Object readObjectId(BsonReader reader, DecoderContext ctx) {
        return new JsonObject().put(OID_FIELD, (Object)reader.readObjectId().toHexString());
    }

    @Override
    protected void writeObjectId(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        JsonObject json = (JsonObject)value;
        ObjectId objectId = new ObjectId(json.getString(OID_FIELD));
        writer.writeObjectId(objectId);
    }

    @Override
    protected Object readDateTime(BsonReader reader, DecoderContext ctx) {
        JsonObject result = new JsonObject();
        result.put(DATE_FIELD, (Object)OffsetDateTime.ofInstant(Instant.ofEpochMilli(reader.readDateTime()), ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        return result;
    }

    @Override
    protected void writeDateTime(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        writer.writeDateTime(OffsetDateTime.parse(((JsonObject)value).getString(DATE_FIELD)).toInstant().toEpochMilli());
    }

    @Override
    protected Object readBinary(BsonReader reader, DecoderContext ctx) {
        JsonObject result = new JsonObject();
        BsonBinary bsonBinary = reader.readBinaryData();
        result.put(BINARY_FIELD, (Object)bsonBinary.getData()).put(TYPE_FIELD, (Object)bsonBinary.getType());
        return result;
    }

    @Override
    protected void writeBinary(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        JsonObject binaryJsonObject = (JsonObject)value;
        byte type = Optional.ofNullable(binaryJsonObject.getInteger(TYPE_FIELD)).map(Integer::byteValue).orElse(BsonBinarySubType.BINARY.getValue());
        BsonBinary bson = new BsonBinary(type, binaryJsonObject.getBinary(BINARY_FIELD));
        writer.writeBinaryData(bson);
    }

    @Override
    protected Object readTimeStamp(BsonReader reader, DecoderContext ctx) {
        JsonObject result = new JsonObject();
        JsonObject timeStampComponent = new JsonObject();
        BsonTimestamp bson = reader.readTimestamp();
        timeStampComponent.put(TIMESTAMP_TIME_FIELD, (Object)bson.getTime());
        timeStampComponent.put(TIMESTAMP_INCREMENT_FIELD, (Object)bson.getInc());
        result.put(TIMESTAMP_FIELD, (Object)timeStampComponent);
        return result;
    }

    @Override
    protected void writeTimeStamp(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        JsonObject timeStamp = ((JsonObject)value).getJsonObject(TIMESTAMP_FIELD);
        BsonTimestamp bson = new BsonTimestamp(timeStamp.getInteger(TIMESTAMP_TIME_FIELD).intValue(), timeStamp.getInteger(TIMESTAMP_INCREMENT_FIELD).intValue());
        writer.writeTimestamp(bson);
    }

    @Override
    protected void writeNumberLong(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        long aLong = ((JsonObject)value).getLong(LONG_FIELD);
        writer.writeInt64(aLong);
    }

    @Override
    protected void writeNumberDecimal(BsonWriter writer, String name, Object value, EncoderContext ctx) {
        if (value instanceof JsonObject) {
            String decimal = ((JsonObject)value).getString(DECIMAL_FIELD);
            writer.writeDecimal128(Decimal128.parse((String)decimal));
            return;
        }
        writer.writeDecimal128(new Decimal128((BigDecimal)value));
    }

    @Override
    protected Object readNumberDecimal(BsonReader reader, DecoderContext ctx) {
        Decimal128 decimal128 = reader.readDecimal128();
        return decimal128.bigDecimalValue();
    }
}

