/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.Arguments;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.mqtt.MqttClientOptionsConverter;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class MqttClientOptions
extends NetClientOptions {
    public static final int DEFAULT_PORT = 1883;
    public static final int DEFAULT_TSL_PORT = 8883;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_WILL_QOS = 0;
    public static final int DEFAULT_KEEP_ALIVE_INTERVAL = 30;
    public static final int DEFAULT_MAX_INFLIGHT_QUEUE = 10;
    public static final boolean DEFAULT_CLEAN_SESSION = true;
    public static final boolean DEFAULT_WILL_FLAG = false;
    public static final boolean DEFAULT_WILL_RETAIN = false;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = -1;
    public static final int DEFAULT_ACK_TIMEOUT = -1;
    public static final boolean DEFAULT_AUTO_ACK = true;
    private String clientId;
    private String username;
    private String password;
    private String willTopic;
    private Buffer willMessageBytes;
    private boolean cleanSession = true;
    private boolean willFlag = false;
    private int willQoS = 0;
    private boolean willRetain = false;
    private int keepAliveInterval = 30;
    private boolean isAutoKeepAlive = true;
    private boolean isAutoGeneratedClientId = true;
    private int maxInflightQueue = 10;
    private int maxMessageSize = -1;
    private int ackTimeout = -1;
    private boolean autoAck = true;

    public MqttClientOptions() {
        this.init();
    }

    private void init() {
        this.cleanSession = true;
        this.willFlag = false;
        this.willQoS = 0;
        this.willRetain = false;
        this.keepAliveInterval = 30;
        this.isAutoKeepAlive = true;
        this.isAutoGeneratedClientId = true;
        this.maxInflightQueue = 10;
        this.maxMessageSize = -1;
        this.ackTimeout = -1;
        this.autoAck = true;
    }

    public MqttClientOptions(JsonObject json) {
        super(json);
        this.init();
        MqttClientOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        if (!json.containsKey("willMessageBytes") && json.containsKey("willMessage")) {
            this.willMessageBytes = Buffer.buffer((String)json.getString("willMessage"));
        }
    }

    public MqttClientOptions(MqttClientOptions other) {
        super((NetClientOptions)other);
        this.clientId = other.clientId;
        this.username = other.username;
        this.password = other.password;
        this.willTopic = other.willTopic;
        this.willMessageBytes = other.willMessageBytes;
        this.cleanSession = other.cleanSession;
        this.willFlag = other.willFlag;
        this.willQoS = other.willQoS;
        this.willRetain = other.willRetain;
        this.keepAliveInterval = other.keepAliveInterval;
        this.isAutoKeepAlive = other.isAutoKeepAlive;
        this.isAutoGeneratedClientId = other.isAutoGeneratedClientId;
        this.maxInflightQueue = other.maxInflightQueue;
        this.maxMessageSize = other.maxMessageSize;
        this.ackTimeout = other.ackTimeout;
        this.autoAck = other.autoAck;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public boolean isWillFlag() {
        return this.willFlag;
    }

    public boolean isWillRetain() {
        return this.willRetain;
    }

    public int getWillQoS() {
        return this.willQoS;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    @Deprecated
    @GenIgnore
    public String getWillMessage() {
        return this.willMessageBytes.toString(StandardCharsets.UTF_8);
    }

    public Buffer getWillMessageBytes() {
        return this.willMessageBytes;
    }

    public MqttClientOptions setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public MqttClientOptions setUsername(String username) {
        this.username = username;
        return this;
    }

    public MqttClientOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public MqttClientOptions setWillTopic(String willTopic) {
        this.willTopic = willTopic;
        return this;
    }

    @Deprecated
    @GenIgnore
    public MqttClientOptions setWillMessage(String willMessage) {
        this.willMessageBytes = Buffer.buffer((byte[])willMessage.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    public MqttClientOptions setWillMessageBytes(Buffer willMessage) {
        this.willMessageBytes = willMessage;
        return this;
    }

    public MqttClientOptions setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        return this;
    }

    public MqttClientOptions setWillFlag(boolean willFlag) {
        this.willFlag = willFlag;
        return this;
    }

    public MqttClientOptions setWillQoS(int willQoS) {
        this.willQoS = willQoS;
        return this;
    }

    public MqttClientOptions setWillRetain(boolean willRetain) {
        this.willRetain = willRetain;
        return this;
    }

    public MqttClientOptions setKeepAliveInterval(int keepAliveInterval) {
        if (keepAliveInterval < 1) {
            throw new IllegalArgumentException("Invalid keep alive interval " + keepAliveInterval);
        }
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    public int getAckTimeout() {
        return this.ackTimeout;
    }

    public MqttClientOptions setAckTimeout(int ackTimeoutSeconds) {
        if (ackTimeoutSeconds == 0 || ackTimeoutSeconds < -1) {
            throw new IllegalArgumentException("timeout must be > 0 or equal to -1");
        }
        this.ackTimeout = ackTimeoutSeconds;
        return this;
    }

    public int getMaxInflightQueue() {
        return this.maxInflightQueue;
    }

    public MqttClientOptions setMaxInflightQueue(int maxInflightQueue) {
        this.maxInflightQueue = maxInflightQueue;
        return this;
    }

    public MqttClientOptions setAutoKeepAlive(boolean isAutoKeepAlive) {
        this.isAutoKeepAlive = isAutoKeepAlive;
        return this;
    }

    public MqttClientOptions setAutoGeneratedClientId(boolean isAutoGeneratedClientId) {
        this.isAutoGeneratedClientId = isAutoGeneratedClientId;
        return this;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isAutoKeepAlive() {
        return this.isAutoKeepAlive;
    }

    public boolean isAutoGeneratedClientId() {
        return this.isAutoGeneratedClientId;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public MqttClientOptions setReceiveBufferSize(int receiveBufferSize) {
        if (this.maxMessageSize > 0 && receiveBufferSize > 0) {
            Arguments.require((receiveBufferSize >= this.maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public MqttClientOptions setMaxMessageSize(int maxMessageSize) {
        Arguments.require((maxMessageSize > 0 || maxMessageSize == -1 ? 1 : 0) != 0, (String)"maxMessageSize must be > 0");
        if (maxMessageSize > 0 && this.getReceiveBufferSize() > 0) {
            Arguments.require((this.getReceiveBufferSize() >= maxMessageSize ? 1 : 0) != 0, (String)"Receiver buffer size can't be lower than max message size");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    @Deprecated
    public MqttClientOptions setIdleTimeout(int idleTimeout) {
        if (idleTimeout > 0) {
            return this.setKeepAliveInterval(idleTimeout);
        }
        return this;
    }

    public int getIdleTimeout() {
        return 0;
    }

    public MqttClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public MqttClientOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public MqttClientOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
        return this;
    }

    public MqttClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public MqttClientOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public MqttClientOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public MqttClientOptions setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public MqttClientOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public MqttClientOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public MqttClientOptions setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public MqttClientOptions setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public MqttClientOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public MqttClientOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public MqttClientOptions addCrlPath(String crlPath) throws NullPointerException {
        super.addCrlPath(crlPath);
        return this;
    }

    public MqttClientOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        super.addCrlValue(crlValue);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        MqttClientOptionsConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return "Options {clientId='" + this.clientId + '\'' + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", willTopic='" + this.willTopic + '\'' + ", willMessageBytes='" + this.willMessageBytes + '\'' + ", cleanSession=" + this.cleanSession + ", willFlag=" + this.willFlag + ", willQoS=" + this.willQoS + ", willRetain=" + this.willRetain + ", keepAliveTimeSeconds=" + this.keepAliveInterval + ", isAutoKeepAlive=" + this.isAutoKeepAlive + ", isAutoGeneratedClientId=" + this.isAutoGeneratedClientId + ", isAutoAck=" + this.autoAck + '}';
    }
}

