/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgNotice;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlConnection;

@VertxGen
public interface PgConnection
extends SqlConnection {
    public static void connect(Vertx vertx, PgConnectOptions options, Handler<AsyncResult<PgConnection>> handler) {
        Future<PgConnection> fut = PgConnection.connect(vertx, options);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public static Future<PgConnection> connect(Vertx vertx, PgConnectOptions options) {
        return PgConnectionImpl.connect((ContextInternal)vertx.getOrCreateContext(), options);
    }

    public static void connect(Vertx vertx, Handler<AsyncResult<PgConnection>> handler) {
        PgConnection.connect(vertx, PgConnectOptions.fromEnv(), handler);
    }

    public static Future<PgConnection> connect(Vertx vertx) {
        return PgConnection.connect(vertx, PgConnectOptions.fromEnv());
    }

    public static void connect(Vertx vertx, String connectionUri, Handler<AsyncResult<PgConnection>> handler) {
        PgConnection.connect(vertx, PgConnectOptions.fromUri(connectionUri), handler);
    }

    public static Future<PgConnection> connect(Vertx vertx, String connectionUri) {
        return PgConnection.connect(vertx, PgConnectOptions.fromUri(connectionUri));
    }

    @Fluent
    public PgConnection notificationHandler(Handler<PgNotification> var1);

    @Fluent
    public PgConnection noticeHandler(Handler<PgNotice> var1);

    public PgConnection cancelRequest(Handler<AsyncResult<Void>> var1);

    public int processId();

    public int secretKey();

    @Fluent
    public PgConnection prepare(String var1, Handler<AsyncResult<PreparedStatement>> var2);

    @Fluent
    public PgConnection exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public PgConnection closeHandler(Handler<Void> var1);

    public static PgConnection cast(SqlConnection sqlConnection) {
        return (PgConnection)sqlConnection;
    }
}

