/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.PgNoticeConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class PgNotice {
    private String severity;
    private String code;
    private String message;
    private String detail;
    private String hint;
    private String position;
    private String internalPosition;
    private String internalQuery;
    private String where;
    private String file;
    private String line;
    private String routine;
    private String schema;
    private String table;
    private String column;
    private String dataType;
    private String constraint;

    public PgNotice() {
    }

    public PgNotice(JsonObject json) {
        PgNoticeConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getSeverity() {
        return this.severity;
    }

    public PgNotice setSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    public String getCode() {
        return this.code;
    }

    public PgNotice setCode(String code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public PgNotice setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getDetail() {
        return this.detail;
    }

    public PgNotice setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public PgNotice setHint(String hint) {
        this.hint = hint;
        return this;
    }

    public String getPosition() {
        return this.position;
    }

    public PgNotice setPosition(String position) {
        this.position = position;
        return this;
    }

    public String getInternalPosition() {
        return this.internalPosition;
    }

    public PgNotice setInternalPosition(String internalPosition) {
        this.internalPosition = internalPosition;
        return this;
    }

    public String getInternalQuery() {
        return this.internalQuery;
    }

    public PgNotice setInternalQuery(String internalQuery) {
        this.internalQuery = internalQuery;
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public PgNotice setWhere(String where) {
        this.where = where;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public PgNotice setFile(String file) {
        this.file = file;
        return this;
    }

    public String getLine() {
        return this.line;
    }

    public PgNotice setLine(String line) {
        this.line = line;
        return this;
    }

    public String getRoutine() {
        return this.routine;
    }

    public PgNotice setRoutine(String routine) {
        this.routine = routine;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public PgNotice setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public PgNotice setTable(String table) {
        this.table = table;
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public PgNotice setColumn(String column) {
        this.column = column;
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public PgNotice setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public PgNotice setConstraint(String constraint) {
        this.constraint = constraint;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PgNoticeConverter.toJson(this, json);
        return json;
    }

    public void log(Logger logger) {
        logger.warn((Object)("Backend notice: severity='" + this.getSeverity() + "', code='" + this.getCode() + "', message='" + this.getMessage() + "', detail='" + this.getDetail() + "', hint='" + this.getHint() + "', position='" + this.getPosition() + "', internalPosition='" + this.getInternalPosition() + "', internalQuery='" + this.getInternalQuery() + "', where='" + this.getWhere() + "', file='" + this.getFile() + "', line='" + this.getLine() + "', routine='" + this.getRoutine() + "', schema='" + this.getSchema() + "', table='" + this.getTable() + "', column='" + this.getColumn() + "', dataType='" + this.getDataType() + "', constraint='" + this.getConstraint() + "'"));
    }

    public String toString() {
        return "NoticeResponse{severity='" + this.getSeverity() + '\'' + ", code='" + this.getCode() + '\'' + ", message='" + this.getMessage() + '\'' + ", detail='" + this.getDetail() + '\'' + ", hint='" + this.getHint() + '\'' + ", position='" + this.getPosition() + '\'' + ", internalPosition='" + this.getInternalPosition() + '\'' + ", internalQuery='" + this.getInternalQuery() + '\'' + ", where='" + this.getWhere() + '\'' + ", file='" + this.getFile() + '\'' + ", line='" + this.getLine() + '\'' + ", routine='" + this.getRoutine() + '\'' + ", schema='" + this.getSchema() + '\'' + ", table='" + this.getTable() + '\'' + ", column='" + this.getColumn() + '\'' + ", dataType='" + this.getDataType() + '\'' + ", constraint='" + this.getConstraint() + '\'' + '}';
    }
}

