/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

public class Line {
    private double a;
    private double b;
    private double c;

    public Line(double a, double b, double c) {
        Line.validate(a, b);
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        Line.validate(a, this.b);
        this.a = a;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        Line.validate(this.a, b);
        this.b = b;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    private static void validate(double a, double b) {
        if (a == 0.0 && b == 0.0) {
            throw new IllegalArgumentException("Invalid line specification: A and B cannot both be zero");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line that = (Line)o;
        if (this.a != that.a) {
            return false;
        }
        if (this.b != that.b) {
            return false;
        }
        return this.c == that.c;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.a);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Line{" + this.a + "," + this.b + "," + this.c + "}";
    }
}

