/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.impl.InitiateSslHandler;
import io.vertx.pgclient.impl.PgDatabaseMetadata;
import io.vertx.pgclient.impl.codec.NoticeResponse;
import io.vertx.pgclient.impl.codec.PgCodec;
import io.vertx.pgclient.impl.codec.TxFailedEvent;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.Notification;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.InitCommand;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.function.Predicate;

public class PgSocketConnection
extends SocketConnectionBase {
    private PgCodec codec;
    public int processId;
    public int secretKey;
    public PgDatabaseMetadata dbMetaData;

    public PgSocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, EventLoopContext context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
    }

    public void init() {
        this.codec = new PgCodec();
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }

    void sendStartupMessage(String username, String password, String database, Map<String, String> properties, Promise<Connection> completionHandler) {
        InitCommand cmd = new InitCommand((SocketConnectionBase)this, username, password, database, properties);
        this.schedule((ContextInternal)this.context, (CommandBase)cmd).onComplete(completionHandler);
    }

    void sendCancelRequestMessage(int processId, int secretKey, Handler<AsyncResult<Void>> handler) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.appendInt(16);
        buffer.appendInt(80877102);
        buffer.appendInt(processId);
        buffer.appendInt(secretKey);
        this.socket.write(buffer, ar -> {
            if (ar.succeeded()) {
                if (this.status == SocketConnectionBase.Status.CONNECTED) {
                    this.status = SocketConnectionBase.Status.CLOSING;
                    this.socket.close();
                }
                handler.handle((Object)Future.succeededFuture());
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    protected void handleMessage(Object msg) {
        super.handleMessage(msg);
        if (msg instanceof Notification || msg instanceof TxFailedEvent || msg instanceof NoticeResponse) {
            this.handleEvent(msg);
        }
    }

    protected void handleException(Throwable t) {
        if (t instanceof PgException) {
            this.reportException(t);
        } else {
            super.handleException(t);
        }
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getSecretKey() {
        return this.secretKey;
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.dbMetaData;
    }

    void upgradeToSSLConnection(Handler<AsyncResult<Void>> completionHandler) {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        Promise upgradePromise = Promise.promise();
        upgradePromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                Throwable cause = ar.cause();
                if (cause instanceof DecoderException) {
                    DecoderException err = (DecoderException)cause;
                    cause = err.getCause();
                }
                completionHandler.handle((Object)Future.failedFuture((Throwable)cause));
            }
        });
        pipeline.addBefore("handler", "initiate-ssl-handler", (ChannelHandler)new InitiateSslHandler(this, (Promise<Void>)upgradePromise));
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        if (cmd instanceof TxCommand) {
            TxCommand tx = (TxCommand)cmd;
            SimpleQueryCommand cmd2 = new SimpleQueryCommand(tx.kind.sql, false, false, QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
            super.doSchedule((CommandBase)cmd2, ar -> handler.handle((Object)ar.map(tx.result)));
        } else {
            super.doSchedule(cmd, handler);
        }
    }

    public boolean isIndeterminatePreparedStatementError(Throwable error) {
        if (error instanceof PgException) {
            String code = ((PgException)error).getCode();
            return "42P18".equals(code) || "42804".equals(code) || "42P08".equals(code);
        }
        return false;
    }
}

