/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonClient;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonTransportOptions;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonSaslClientAuthenticatorImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProtonClientImpl
implements ProtonClient {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonClientImpl.class);
    private final Vertx vertx;

    public ProtonClientImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void connect(String host, int port, Handler<AsyncResult<ProtonConnection>> handler) {
        this.connect(host, port, null, null, handler);
    }

    @Override
    public void connect(String host, int port, String username, String password, Handler<AsyncResult<ProtonConnection>> handler) {
        this.connect(new ProtonClientOptions(), host, port, username, password, handler);
    }

    @Override
    public void connect(ProtonClientOptions options, String host, int port, Handler<AsyncResult<ProtonConnection>> handler) {
        this.connect(options, host, port, null, null, handler);
    }

    @Override
    public void connect(ProtonClientOptions options, String host, int port, String username, String password, Handler<AsyncResult<ProtonConnection>> handler) {
        NetClient netClient = this.vertx.createNetClient((NetClientOptions)options);
        this.connectNetClient(netClient, host, port, username, password, new ConnectCompletionHandler(handler, netClient), options);
    }

    private void connectNetClient(NetClient netClient, String host, int port, String username, String password, ConnectCompletionHandler connectHandler, ProtonClientOptions options) {
        String serverName = options.getSniServerName() != null ? options.getSniServerName() : (options.getVirtualHost() != null ? options.getVirtualHost() : null);
        netClient.connect(port, host, serverName, res -> {
            if (res.succeeded()) {
                String virtualHost = options.getVirtualHost() != null ? options.getVirtualHost() : host;
                ProtonConnectionImpl conn = new ProtonConnectionImpl(this.vertx, virtualHost, (ContextInternal)Vertx.currentContext());
                conn.disconnectHandler((Handler<ProtonConnection>)((Handler)h -> {
                    LOG.trace((Object)"Connection disconnected");
                    if (!connectHandler.isComplete()) {
                        connectHandler.handle((AsyncResult<ProtonConnection>)Future.failedFuture((Throwable)new VertxException("Disconnected")));
                    }
                }));
                ProtonSaslClientAuthenticatorImpl authenticator = new ProtonSaslClientAuthenticatorImpl(username, password, options.getEnabledSaslMechanisms(), options.getAuthorizationId(), connectHandler);
                ProtonTransportOptions transportOptions = new ProtonTransportOptions();
                transportOptions.setHeartbeat(options.getHeartbeat());
                transportOptions.setMaxFrameSize(options.getMaxFrameSize());
                conn.bindClient(netClient, (NetSocket)res.result(), authenticator, transportOptions);
                conn.flush();
            } else {
                connectHandler.handle((AsyncResult<ProtonConnection>)Future.failedFuture((Throwable)res.cause()));
            }
        });
    }

    static class ConnectCompletionHandler
    implements Handler<AsyncResult<ProtonConnection>> {
        private AtomicBoolean completed = new AtomicBoolean();
        private Handler<AsyncResult<ProtonConnection>> applicationConnectHandler;
        private NetClient netClient;

        ConnectCompletionHandler(Handler<AsyncResult<ProtonConnection>> applicationConnectHandler, NetClient netClient) {
            this.applicationConnectHandler = Objects.requireNonNull(applicationConnectHandler);
            this.netClient = Objects.requireNonNull(netClient);
        }

        public boolean isComplete() {
            return this.completed.get();
        }

        public void handle(AsyncResult<ProtonConnection> event) {
            if (this.completed.compareAndSet(false, true)) {
                if (event.failed()) {
                    this.netClient.close();
                }
                this.applicationConnectHandler.handle(event);
            }
        }
    }
}

