/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.sasl.impl;

import io.vertx.proton.sasl.ProtonSaslMechanism;
import io.vertx.proton.sasl.impl.ProtonSaslMechanismImpl;
import java.nio.charset.StandardCharsets;
import java.security.Principal;

public class ProtonSaslPlainImpl
extends ProtonSaslMechanismImpl {
    public static final String MECH_NAME = "PLAIN";

    @Override
    public int getPriority() {
        return ProtonSaslMechanism.PRIORITY.LOWER.getValue();
    }

    @Override
    public String getName() {
        return MECH_NAME;
    }

    @Override
    public byte[] getInitialResponse() {
        String authzId = this.getAuthorizationId();
        String username = this.getUsername();
        String password = this.getPassword();
        if (authzId == null) {
            authzId = "";
        }
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        byte[] authzIdBytes = authzId.getBytes(StandardCharsets.UTF_8);
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[authzIdBytes.length + usernameBytes.length + passwordBytes.length + 2];
        System.arraycopy(authzIdBytes, 0, data, 0, authzIdBytes.length);
        System.arraycopy(usernameBytes, 0, data, 1 + authzIdBytes.length, usernameBytes.length);
        System.arraycopy(passwordBytes, 0, data, 2 + authzIdBytes.length + usernameBytes.length, passwordBytes.length);
        return data;
    }

    @Override
    public byte[] getChallengeResponse(byte[] challenge) {
        return EMPTY;
    }

    @Override
    public boolean isApplicable(String username, String password, Principal localPrincipal) {
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }
}

