/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.keys;

import io.vertx.redis.client.impl.keys.BeginSearch;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class BeginSearchKeyword
implements BeginSearch {
    private static final byte UPPER_CASE_OFFSET = -32;
    private final byte[] keyword;
    private final int startsFrom;

    public BeginSearchKeyword(String keyword, int startsFrom) {
        this.keyword = keyword.getBytes(StandardCharsets.UTF_8);
        this.startsFrom = startsFrom;
        BeginSearchKeyword.toUpperCase(this.keyword);
    }

    @Override
    public int begin(List<byte[]> args, int arity) {
        int start;
        for (int i = start = this.startsFrom >= 0 ? this.startsFrom : Math.abs(arity) + this.startsFrom; i < args.size(); ++i) {
            if (!this.match(args.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    private static byte toUpperCase(byte b) {
        if (b < 97 || b > 122) {
            return b;
        }
        return (byte)(b + -32);
    }

    private static void toUpperCase(byte[] bytes) {
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] < 97 || bytes[i] > 122) continue;
            bytes[i] = (byte)(bytes[i] + -32);
        }
    }

    private boolean match(byte[] a) {
        if (a != null) {
            int length = a.length;
            if (this.keyword.length != length) {
                return false;
            }
            for (int i = 0; i < this.keyword.length; ++i) {
                if (this.keyword[i] == BeginSearchKeyword.toUpperCase(a[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

