/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.openapi3.impl;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.ResolverCache;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.contract.RouterFactoryException;
import io.vertx.ext.web.api.contract.impl.BaseRouterFactory;
import io.vertx.ext.web.api.contract.impl.RouteToEBServiceHandler;
import io.vertx.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3PathResolver;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenAPI3RequestValidationHandlerImpl;
import io.vertx.ext.web.api.contract.openapi3.impl.OpenApi3Utils;
import io.vertx.ext.web.api.contract.openapi3.impl.SecurityHandlersStore;
import io.vertx.ext.web.handler.PlatformHandler;
import io.vertx.ext.web.handler.ResponseContentTypeHandler;
import io.vertx.ext.web.impl.RouteImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenAPI3RouterFactoryImpl
extends BaseRouterFactory<OpenAPI>
implements OpenAPI3RouterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OpenAPI3RouterFactoryImpl.class);
    private static final String OPENAPI_EXTENSION = "x-vertx-event-bus";
    private static final String OPENAPI_EXTENSION_ADDRESS = "address";
    private static final String OPENAPI_EXTENSION_METHOD_NAME = "method";
    private static final Handler<RoutingContext> NOT_IMPLEMENTED_HANDLER = rc -> rc.fail(501);
    Map<String, OperationValue> operations;
    ResolverCache refsCache;
    SecurityHandlersStore securityHandlers;

    private static Handler<RoutingContext> generateNotAllowedHandler(List<HttpMethod> allowedMethods) {
        return rc -> {
            rc.addHeadersEndHandler(v -> rc.response().headers().add("Allow", allowedMethods.stream().map(HttpMethod::toString).collect(Collectors.joining(", "))));
            rc.fail(405);
        };
    }

    public OpenAPI3RouterFactoryImpl(Vertx vertx, OpenAPI spec, ResolverCache refsCache) {
        super(vertx, spec);
        this.refsCache = refsCache;
        this.operations = new LinkedHashMap<String, OperationValue>();
        this.securityHandlers = new SecurityHandlersStore();
        for (Map.Entry pathEntry : spec.getPaths().entrySet()) {
            for (Map.Entry opEntry : ((PathItem)pathEntry.getValue()).readOperationsMap().entrySet()) {
                if (((Operation)opEntry.getValue()).getOperationId() != null) {
                    this.operations.put(((Operation)opEntry.getValue()).getOperationId(), new OperationValue(HttpMethod.valueOf((String)((PathItem.HttpMethod)opEntry.getKey()).name()), (String)pathEntry.getKey(), (Operation)opEntry.getValue(), (PathItem)pathEntry.getValue()));
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("The operation '" + opEntry.getKey() + "' from path '" + (String)pathEntry.getKey() + "' is being ignored because it doesn't have an operationId"));
            }
        }
    }

    public OpenAPI3RouterFactory addSecuritySchemaScopeValidator(String securitySchemaName, String scopeName, Handler handler) {
        this.securityHandlers.addSecurityRequirement(securitySchemaName, scopeName, (Handler<RoutingContext>)handler);
        return this;
    }

    @Override
    public OpenAPI3RouterFactory addHandlerByOperationId(String operationId, Handler<RoutingContext> handler) {
        if (handler != null) {
            OperationValue op = this.operations.get(operationId);
            if (op == null) {
                throw RouterFactoryException.createOperationIdNotFoundException(operationId);
            }
            op.addUserHandler(handler);
        }
        return this;
    }

    @Override
    public OpenAPI3RouterFactory addFailureHandlerByOperationId(String operationId, Handler<RoutingContext> failureHandler) {
        if (failureHandler != null) {
            OperationValue op = this.operations.get(operationId);
            if (op == null) {
                throw RouterFactoryException.createOperationIdNotFoundException(operationId);
            }
            op.addUserFailureHandler(failureHandler);
        }
        return this;
    }

    @Override
    public OpenAPI3RouterFactory mountServiceFromTag(String tag, String address) {
        for (Map.Entry<String, OperationValue> op : this.operations.entrySet()) {
            if (!op.getValue().hasTag(tag)) continue;
            op.getValue().mountRouteToService(address);
        }
        return this;
    }

    @Override
    public OpenAPI3RouterFactory mountServiceInterface(Class interfaceClass, String address) {
        for (Method m : interfaceClass.getMethods()) {
            String methodName;
            OperationValue op;
            if (!OpenApi3Utils.serviceProxyMethodIsCompatibleHandler(m) || (op = Optional.ofNullable(this.operations.get(methodName = m.getName())).orElseGet(() -> this.operations.entrySet().stream().filter(e -> OpenApi3Utils.sanitizeOperationId((String)e.getKey()).equals(methodName)).map(Map.Entry::getValue).findFirst().orElseGet(() -> null))) == null) continue;
            op.mountRouteToService(address, methodName);
        }
        return this;
    }

    @Override
    public OpenAPI3RouterFactory mountOperationToEventBus(String operationId, String address) {
        OperationValue op = this.operations.get(operationId);
        if (op == null) {
            throw RouterFactoryException.createOperationIdNotFoundException(operationId);
        }
        op.mountRouteToService(address, operationId);
        return this;
    }

    @Override
    public OpenAPI3RouterFactory mountServicesFromExtensions() {
        for (Map.Entry<String, OperationValue> opEntry : this.operations.entrySet()) {
            OperationValue operation = opEntry.getValue();
            Object extensionVal = OpenApi3Utils.getAndMergeServiceExtension(OPENAPI_EXTENSION, OPENAPI_EXTENSION_ADDRESS, OPENAPI_EXTENSION_METHOD_NAME, operation.pathModel, operation.operationModel);
            if (extensionVal == null) continue;
            if (extensionVal instanceof String) {
                operation.mountRouteToService((String)extensionVal, opEntry.getKey());
                continue;
            }
            if (extensionVal instanceof Map) {
                JsonObject extensionMap = new JsonObject((Map)extensionVal);
                String address = extensionMap.getString(OPENAPI_EXTENSION_ADDRESS);
                String methodName = extensionMap.getString(OPENAPI_EXTENSION_METHOD_NAME);
                JsonObject sanitizedMap = OpenApi3Utils.sanitizeDeliveryOptionsExtension(extensionMap);
                if (address == null) {
                    throw RouterFactoryException.createWrongExtension("Extension x-vertx-event-bus must define address");
                }
                if (methodName == null) {
                    operation.mountRouteToService(address, opEntry.getKey());
                    continue;
                }
                operation.mountRouteToService(address, methodName, sanitizedMap);
                continue;
            }
            throw RouterFactoryException.createWrongExtension("Extension x-vertx-event-bus must be or string or a JsonObject");
        }
        return this;
    }

    public OpenAPI3RouterFactory addSecurityHandler(String securitySchemaName, Handler handler) {
        this.securityHandlers.addSecurityRequirement(securitySchemaName, (Handler<RoutingContext>)handler);
        return this;
    }

    @Override
    public Router getRouter() {
        Router router = Router.router((Vertx)this.vertx);
        Route globalRoute = router.route();
        globalRoute.handler((Handler)this.getBodyHandler());
        List<Handler<RoutingContext>> globalHandlers = this.getGlobalHandlers();
        for (Handler<RoutingContext> globalHandler : globalHandlers) {
            globalRoute.handler(globalHandler);
        }
        List<Handler<RoutingContext>> globalSecurityHandlers = this.securityHandlers.solveSecurityHandlers(((OpenAPI)this.spec).getSecurity(), this.getOptions().isRequireSecurityHandlers());
        for (OperationValue operation : this.operations.values()) {
            if (!this.options.isMountNotImplementedHandler() && !operation.isConfigured()) continue;
            ArrayList<Handler<RoutingContext>> handlersToLoad = new ArrayList<Handler<RoutingContext>>();
            ArrayList<Handler<RoutingContext>> failureHandlersToLoad = new ArrayList<Handler<RoutingContext>>();
            if (operation.getOperationModel().getSecurity() != null) {
                handlersToLoad.addAll(this.securityHandlers.solveSecurityHandlers(operation.getOperationModel().getSecurity(), this.getOptions().isRequireSecurityHandlers()));
            } else {
                handlersToLoad.addAll(globalSecurityHandlers);
            }
            OpenAPI3RequestValidationHandlerImpl validationHandler = new OpenAPI3RequestValidationHandlerImpl(operation.getOperationModel(), operation.getParameters(), (OpenAPI)this.spec, this.refsCache);
            handlersToLoad.add(validationHandler);
            if (operation.isConfigured()) {
                handlersToLoad.addAll(operation.getUserHandlers());
                failureHandlersToLoad.addAll(operation.getUserFailureHandlers());
                if (operation.mustMountRouteToService()) {
                    handlersToLoad.add(operation.getEbServiceDeliveryOptions() != null ? RouteToEBServiceHandler.build(this.vertx.eventBus(), operation.getEbServiceAddress(), operation.getEbServiceMethodName(), operation.getEbServiceDeliveryOptions(), this.getExtraOperationContextPayloadMapper()) : RouteToEBServiceHandler.build(this.vertx.eventBus(), operation.getEbServiceAddress(), operation.getEbServiceMethodName(), this.getExtraOperationContextPayloadMapper()));
                }
            } else {
                List<HttpMethod> configuredMethodsForThisPath = this.operations.values().stream().filter(ov -> operation.path.equals(((OperationValue)ov).path)).filter(OperationValue::isConfigured).map(OperationValue::getMethod).collect(Collectors.toList());
                if (!configuredMethodsForThisPath.isEmpty()) {
                    handlersToLoad.add(OpenAPI3RouterFactoryImpl.generateNotAllowedHandler(configuredMethodsForThisPath));
                } else {
                    handlersToLoad.add(NOT_IMPLEMENTED_HANDLER);
                }
            }
            OpenAPI3PathResolver pathResolver = new OpenAPI3PathResolver(operation.getPath(), operation.getParameters());
            Route route = pathResolver.solve().map(solvedRegex -> router.routeWithRegex(operation.getMethod(), solvedRegex.toString())).orElseGet(() -> router.route(operation.getMethod(), operation.getPath()));
            String exposeConfigurationKey = this.getOptions().getOperationModelKey();
            if (exposeConfigurationKey != null) {
                route.handler((Handler)((PlatformHandler)context -> context.put(exposeConfigurationKey, (Object)operation.getOperationModel()).next()));
            }
            HashSet consumes = new HashSet();
            HashSet produces = new HashSet();
            if (operation.getOperationModel().getRequestBody() != null && operation.getOperationModel().getRequestBody().getContent() != null) {
                consumes.addAll(operation.getOperationModel().getRequestBody().getContent().keySet());
            }
            if (operation.getOperationModel().getResponses() != null) {
                for (ApiResponse apiResponse : operation.getOperationModel().getResponses().values()) {
                    if (apiResponse.getContent() == null) continue;
                    produces.addAll(apiResponse.getContent().keySet());
                }
            }
            for (String string : consumes) {
                route.consumes(string);
            }
            for (String string : produces) {
                route.produces(string);
            }
            if (!consumes.isEmpty()) {
                ((RouteImpl)route).setEmptyBodyPermittedWithConsumes(!validationHandler.isBodyRequired());
            }
            if (this.options.isMountResponseContentTypeHandler() && produces.size() != 0) {
                route.handler((Handler)ResponseContentTypeHandler.create());
            }
            route.setRegexGroupsNames(new ArrayList<String>(pathResolver.getMappedGroups().values()));
            for (Handler handler : handlersToLoad) {
                route.handler(handler);
            }
            for (Handler handler : failureHandlersToLoad) {
                route.failureHandler(handler);
            }
        }
        if (this.options.isMountValidationFailureHandler()) {
            router.errorHandler(400, this.getValidationFailureHandler());
        }
        if (this.options.isMountNotImplementedHandler()) {
            router.errorHandler(501, this.getNotImplementedFailureHandler());
        }
        return router;
    }

    private static class OperationValue {
        private HttpMethod method;
        private String path;
        private PathItem pathModel;
        private Operation operationModel;
        private List<Parameter> parameters;
        private List<String> tags;
        private List<Handler<RoutingContext>> userHandlers;
        private List<Handler<RoutingContext>> userFailureHandlers;
        private String ebServiceAddress;
        private String ebServiceMethodName;
        private JsonObject ebServiceDeliveryOptions;

        private OperationValue(HttpMethod method, String path, Operation operationModel, PathItem pathModel) {
            this.method = method;
            this.path = path;
            this.pathModel = pathModel;
            this.operationModel = operationModel;
            this.tags = operationModel.getTags();
            ArrayList<Parameter> opParams = operationModel.getParameters() == null ? new ArrayList() : operationModel.getParameters();
            ArrayList<Parameter> parentParams = pathModel.getParameters() == null ? new ArrayList() : pathModel.getParameters();
            this.parameters = OpenApi3Utils.mergeParameters(opParams, parentParams);
            this.userHandlers = new ArrayList<Handler<RoutingContext>>();
            this.userFailureHandlers = new ArrayList<Handler<RoutingContext>>();
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public Operation getOperationModel() {
            return this.operationModel;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public String getPath() {
            return this.path;
        }

        public PathItem getPathModel() {
            return this.pathModel;
        }

        public void addUserHandler(Handler<RoutingContext> userHandler) {
            this.userHandlers.add(userHandler);
        }

        public void addUserFailureHandler(Handler<RoutingContext> userFailureHandler) {
            this.userFailureHandlers.add(userFailureHandler);
        }

        public List<Handler<RoutingContext>> getUserHandlers() {
            return this.userHandlers;
        }

        public List<Handler<RoutingContext>> getUserFailureHandlers() {
            return this.userFailureHandlers;
        }

        public boolean isConfigured() {
            return this.userHandlers.size() != 0 || this.mustMountRouteToService();
        }

        public List<String> getTags() {
            return this.tags;
        }

        public boolean hasTag(String tag) {
            return this.tags != null && this.tags.contains(tag);
        }

        public void mountRouteToService(String address) {
            this.ebServiceAddress = address;
            this.ebServiceMethodName = OpenApi3Utils.sanitizeOperationId(this.operationModel.getOperationId());
        }

        public void mountRouteToService(String address, String methodName) {
            this.ebServiceAddress = address;
            this.ebServiceMethodName = OpenApi3Utils.sanitizeOperationId(methodName);
        }

        public void mountRouteToService(String address, String methodName, JsonObject deliveryOptions) {
            this.ebServiceAddress = address;
            this.ebServiceMethodName = OpenApi3Utils.sanitizeOperationId(methodName);
            this.ebServiceDeliveryOptions = deliveryOptions;
        }

        public boolean mustMountRouteToService() {
            return this.ebServiceAddress != null;
        }

        public String getEbServiceAddress() {
            return this.ebServiceAddress;
        }

        public String getEbServiceMethodName() {
            return this.ebServiceMethodName;
        }

        public JsonObject getEbServiceDeliveryOptions() {
            return this.ebServiceDeliveryOptions;
        }
    }
}

