/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import java.util.Hashtable;

public class ExpiredTransactionScanner
implements ExpiryScanner {
    private String _typeName;
    private String _movedTypeName;
    private ObjectStore _objectStore = TxControl.getStore();
    private Hashtable _scanM = null;
    private Hashtable _scanN = null;

    public ExpiredTransactionScanner(String typeName, String movedTypeName) {
        this._typeName = typeName;
        this._movedTypeName = movedTypeName;
    }

    public void scan() {
        boolean initialScan = false;
        if (this._scanM == null) {
            this._scanM = new Hashtable();
            initialScan = true;
        }
        try {
            InputObjectState uids = new InputObjectState();
            if (this._objectStore.allObjUids(this._typeName, uids)) {
                Uid theUid = new Uid(Uid.nullUid());
                boolean endOfUids = false;
                while (!endOfUids) {
                    theUid.unpack(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        endOfUids = true;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    if (initialScan) {
                        this._scanM.put(newUid, newUid);
                        continue;
                    }
                    if (!this._scanM.contains(newUid)) {
                        if (this._scanN == null) {
                            this._scanN = new Hashtable();
                        }
                        this._scanN.put(newUid, newUid);
                        continue;
                    }
                    if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                        tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionScanner_4", new Object[]{newUid});
                    }
                    try {
                        boolean moved;
                        InputObjectState state = this._objectStore.read_committed(newUid, this._typeName);
                        if (state == null || (moved = this._objectStore.write_committed(newUid, this._movedTypeName, new OutputObjectState(state)))) continue;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner_3", new Object[]{newUid});
                    }
                    catch (Exception ex) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionScanner_2", new Object[]{newUid, ex});
                        this._scanN.put(newUid, newUid);
                    }
                }
                if (this._scanN != null) {
                    this._scanM = this._scanN;
                    this._scanN = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean toBeUsed() {
        return true;
    }
}

