/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.tsmx.mbeans;

import com.arjuna.ats.internal.tsmx.mbeans.MappingsNotFoundException;
import com.arjuna.ats.internal.tsmx.mbeans.PropertyServiceMBeanWrapper;
import com.arjuna.ats.tsmx.TransactionServiceMX;
import com.arjuna.ats.tsmx.logging.tsmxLogger;
import com.arjuna.common.util.exceptions.ManagementPluginException;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagementPlugin;
import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
import java.io.IOException;

public class PropertyServiceJMXPlugin
implements PropertyManagementPlugin {
    public void initialise(PropertyManagerPluginInterface pm) throws ManagementPluginException, IOException {
        try {
            this.registerPropertyManagers(pm);
        }
        catch (Exception e) {
            throw new ManagementPluginException("Failed to register mbeans: " + e);
        }
    }

    private void registerPropertyManagers(PropertyManagerPluginInterface pm) throws Exception {
        if (!pm.getLocalProperties().isEmpty()) {
            block5: {
                PropertyServiceMBeanWrapper mbean = null;
                try {
                    mbean = new PropertyServiceMBeanWrapper(pm);
                    if (tsmxLogger.logger.isInfoEnabled()) {
                        tsmxLogger.logger.info("Registering mbean for module '" + pm.getName() + "'");
                    }
                    TransactionServiceMX.getTransactionServiceMX().getAgentInterface().getAgent().registerMBean(mbean, mbean.getObjectName());
                }
                catch (MappingsNotFoundException e) {
                    if (!pm.verbose()) break block5;
                    System.err.println("Mappings not found: " + e.toString());
                }
            }
            PropertyManagerPluginInterface[] children = pm.getChildren();
            for (int count = 0; count < children.length; ++count) {
                this.registerPropertyManagers(children[count]);
            }
        }
    }
}

