/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpContext;
import org.mortbay.util.IO;
import org.mortbay.util.Resource;

public class ContextLoader
extends URLClassLoader {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$ContextLoader == null ? (class$org$mortbay$http$ContextLoader = ContextLoader.class$("org.mortbay.http.ContextLoader")) : class$org$mortbay$http$ContextLoader));
    private boolean _java2compliant;
    private ClassLoader _parent;
    private PermissionCollection _permissions;
    private String _urlClassPath;
    private String[] _systemClasses;
    private String[] _serverClasses;
    static /* synthetic */ Class class$org$mortbay$http$ContextLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextLoader(HttpContext context, String classPath, ClassLoader parent, PermissionCollection permisions) throws MalformedURLException, IOException {
        block15: {
            block14: {
                super(new URL[0], parent);
                this._java2compliant = false;
                this._permissions = permisions;
                this._parent = parent;
                this._systemClasses = context.getSystemClasses();
                if (this._systemClasses == null && context.getHttpServer() != null) {
                    this._systemClasses = context.getHttpServer().getSystemClasses();
                }
                this._serverClasses = context.getServerClasses();
                if (this._serverClasses == null && context.getHttpServer() != null) {
                    this._serverClasses = context.getHttpServer().getServerClasses();
                }
                if (this._parent == null) {
                    this._parent = ContextLoader.getSystemClassLoader();
                }
                if (classPath != null) break block14;
                this._urlClassPath = "";
                break block15;
            }
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
            while (tokenizer.hasMoreTokens()) {
                URL url;
                Resource resource;
                block16: {
                    File file;
                    resource = Resource.newResource(tokenizer.nextToken());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Path resource=" + resource));
                    }
                    if ((file = resource.getFile()) != null) {
                        url = resource.getURL();
                        this.addURL(url);
                        this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
                        continue;
                    }
                    if (resource.isDirectory() || file != null) break block16;
                    InputStream in = resource.getInputStream();
                    File lib = new File(context.getTempDirectory(), "lib");
                    if (!lib.exists()) {
                        lib.mkdir();
                        lib.deleteOnExit();
                    }
                    File jar = File.createTempFile("Jetty-", ".jar", lib);
                    jar.deleteOnExit();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Extract " + resource + " to " + jar));
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(jar);
                        IO.copy(in, out);
                    }
                    catch (Throwable throwable) {
                        IO.close(out);
                        throw throwable;
                    }
                    IO.close(out);
                    URL url2 = jar.toURL();
                    this.addURL(url2);
                    this._urlClassPath = this._urlClassPath == null ? url2.toString() : this._urlClassPath + "," + url2.toString();
                    continue;
                }
                url = resource.getURL();
                this.addURL(url);
                this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
            }
        }
        if (log.isDebugEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ClassPath=" + this._urlClassPath));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Permissions=" + this._permissions));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL=" + Arrays.asList(this.getURLs())));
            }
        }
    }

    public void setJava2Compliant(boolean compliant) {
        this._java2compliant = compliant;
    }

    public boolean isJava2Compliant() {
        return this._java2compliant;
    }

    public String toString() {
        if (log.isDebugEnabled()) {
            return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ") / " + this._parent.toString();
        }
        return "ContextLoader@" + this.hashCode();
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc;
        PermissionCollection permissionCollection = pc = this._permissions == null ? super.getPermissions(cs) : this._permissions;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loader.getPermissions(" + cs + ")=" + pc));
        }
        return pc;
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && (this._java2compliant || this.isSystemPath(name)) && !this.isServerPath(name) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try loadClass " + name + " from " + this._parent));
            }
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("loaded " + c));
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try findClass " + name + " from " + this._urlClassPath));
            }
            try {
                c = this.findClass(name);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("loaded " + c));
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && !tried_parent && !this.isServerPath(name) && this._parent != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try loadClass " + name + " from " + this._parent));
            }
            c = this._parent.loadClass(name);
            if (log.isTraceEnabled()) {
                log.trace((Object)("loaded " + c));
            }
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public synchronized URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._java2compliant || this.isSystemPath(name)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try getResource " + name + " from " + this._parent));
            }
            tried_parent = true;
            url = this._parent.getResource(name);
        }
        if (url == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try findResource " + name + " from " + this._urlClassPath));
            }
            if ((url = this.findResource(name)) == null && name.startsWith("/")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("HACK leading / off " + name));
                }
                url = this.findResource(name.substring(1));
            }
        }
        if (url == null && !tried_parent) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("try getResource " + name + " from " + this._parent));
            }
            url = this._parent.getResource(name);
        }
        if (url != null && log.isTraceEnabled()) {
            log.trace((Object)("found " + url));
        }
        return url;
    }

    public boolean isServerPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        if (this._serverClasses != null) {
            for (int i = 0; i < this._serverClasses.length; ++i) {
                if (this._serverClasses[i].startsWith("-")) {
                    if (!name.equals(this._serverClasses[i].substring(1))) continue;
                    return false;
                }
                if (!(this._serverClasses[i].endsWith(".") ? name.startsWith(this._serverClasses[i]) : name.equals(this._serverClasses[i]))) continue;
                return true;
            }
            return false;
        }
        return name.equals("org.mortbay.jetty.Server") || name.startsWith("org.mortbay.http.") || name.startsWith("org.mortbay.start.") || name.startsWith("org.mortbay.stop.");
    }

    public boolean isSystemPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        if (this._systemClasses != null) {
            for (int i = 0; i < this._systemClasses.length; ++i) {
                if (this._systemClasses[i].startsWith("-")) {
                    if (!name.equals(this._systemClasses[i].substring(1))) continue;
                    return false;
                }
                if (!(this._systemClasses[i].endsWith(".") ? name.startsWith(this._systemClasses[i]) : name.equals(this._systemClasses[i]))) continue;
                return true;
            }
            return false;
        }
        return name.startsWith("java.") || name.startsWith("javax.servlet.") || name.startsWith("javax.xml.") || name.startsWith("org.mortbay.") || name.startsWith("org.xml.") || name.startsWith("org.w3c.");
    }

    public void destroy() {
        this._parent = null;
        this._permissions = null;
        this._urlClassPath = null;
    }

    String[] getServerClasses() {
        return this._serverClasses;
    }

    void setServerClasses(String[] serverClasses) {
        this._serverClasses = serverClasses;
    }

    String[] getSystemClasses() {
        return this._systemClasses;
    }

    void setSystemClasses(String[] systemClasses) {
        this._systemClasses = systemClasses;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

