/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.RWLock;
import org.jgroups.util.TimeScheduler;

public class TOTAL
extends Protocol {
    private static final String PROT_NAME = "TOTAL";
    private static final String TRACE_PROP = "trace";
    private long[] AVG_RETRANSMIT_INTERVAL = new long[]{1000L, 2000L, 3000L, 4000L};
    private static final long NULL_ID = -1L;
    private static final int NULL_STATE = -1;
    private static final int RUN = 0;
    private static final int FLUSH = 1;
    private static final int BLOCK = 2;
    private RWLock stateLock = new RWLock();
    private int state = -1;
    private Address addr = null;
    private Address sequencerAddr = null;
    private long sequencerSeqID = -1L;
    private long localSeqID = -1L;
    private long seqID = -1L;
    private SortedMap reqTbl;
    private SortedMap upTbl;
    private AckSenderWindow retransmitter;

    private String _addrToString(Object addr) {
        return addr == null ? "<null>" : (addr instanceof IpAddress ? ((IpAddress)addr).getIpAddress().getHostAddress() + ':' + ((IpAddress)addr).getPort() : addr.toString());
    }

    private String _getName() {
        return PROT_NAME;
    }

    private boolean _setProperties(Properties properties) {
        String value = properties.getProperty(TRACE_PROP);
        if (value != null) {
            properties.remove(TRACE_PROP);
        }
        if (properties.size() > 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("The following properties are not recognized: " + properties.toString()));
            }
            return false;
        }
        return true;
    }

    Vector _requiredDownServices() {
        Vector services = new Vector();
        return services;
    }

    Vector _requiredUpServices() {
        Vector services = new Vector();
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deliverBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            Message msg;
            while ((msg = (Message)this.upTbl.remove(new Long(this.seqID + 1L))) != null) {
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSeqID != -1L) {
                    this.passUp(new Event(1, msg));
                }
                ++this.seqID;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _replayBcast() {
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (this.upTbl.size() > 0 && this.log.isInfoEnabled()) {
                this.log.info((Object)"Replaying undelivered bcasts");
            }
            Iterator it = this.upTbl.entrySet().iterator();
            while (it.hasNext()) {
                Message msg = (Message)it.next().getValue();
                it.remove();
                if (!msg.getSrc().equals(this.addr)) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info((Object)("During replay: discarding BCAST[" + ((Header)msg.getHeader((String)this.getName())).seqID + "] from " + this._addrToString(msg.getSrc())));
                    continue;
                }
                Header header = (Header)msg.removeHeader(this.getName());
                if (header.localSeqID == -1L) continue;
                this._sendBcastRequest(msg, header.localSeqID);
            }
        }
    }

    private Message _sendUcast(Message msg) {
        msg.putHeader(this.getName(), new Header(2, -1L, -1L));
        return msg;
    }

    private void _sendBcastRequest(Message msg) {
        this._sendBcastRequest(msg, ++this.localSeqID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendBcastRequest(Message msg, long id) {
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            this.reqTbl.put(new Long(id), msg);
        }
        this._transmitBcastRequest(id);
        this.retransmitter.add(id, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _transmitBcastRequest(long seqID) {
        if (this.state == -1) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Transmit BCAST_REQ[" + seqID + "] in NULL_STATE"));
            }
            return;
        }
        if (this.state == 2) {
            return;
        }
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            if (!this.reqTbl.containsKey(new Long(seqID))) {
                this.retransmitter.ack(seqID);
                return;
            }
        }
        Message reqMsg = new Message(this.sequencerAddr, this.addr, new byte[0]);
        reqMsg.putHeader(this.getName(), new Header(0, seqID, -1L));
        this.passDown(new Event(1, reqMsg));
    }

    private void _recvUcast(Message msg) {
        msg.removeHeader(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _recvBcast(Message msg) {
        Header header = (Header)msg.getHeader(this.getName());
        SortedMap sortedMap = this.upTbl;
        synchronized (sortedMap) {
            if (header.seqID <= this.seqID) {
                return;
            }
            this.upTbl.put(new Long(header.seqID), msg);
        }
        this._deliverBcast();
    }

    private void _recvBcastRequest(Message msg) {
        if (!this.addr.equals(this.sequencerAddr)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Received bcast request but not a sequencer");
            }
            return;
        }
        if (this.state == 2) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Blocked, discard bcast req");
            }
            return;
        }
        Header header = (Header)msg.getHeader(this.getName());
        ++this.sequencerSeqID;
        Message repMsg = new Message(msg.getSrc(), this.addr, new byte[0]);
        repMsg.putHeader(this.getName(), new Header(1, header.localSeqID, this.sequencerSeqID));
        this.passDown(new Event(1, repMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _recvBcastReply(Header header) {
        long id;
        Message msg;
        if (this.state == 2) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Blocked, discard bcast rep");
            }
            return;
        }
        SortedMap sortedMap = this.reqTbl;
        synchronized (sortedMap) {
            msg = (Message)this.reqTbl.remove(new Long(header.localSeqID));
        }
        if (msg != null) {
            this.retransmitter.ack(header.localSeqID);
            id = header.localSeqID;
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Bcast reply to non-existent BCAST_REQ[" + header.localSeqID + "], Sending NULL bcast"));
            }
            id = -1L;
            msg = new Message(null, this.addr, new byte[0]);
        }
        msg.putHeader(this.getName(), new Header(3, id, header.seqID));
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retransmitBcastRequest(long seqID) {
        block6: {
            try {
                this.stateLock.readLock();
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Retransmit BCAST_REQ[" + seqID + ']'));
                    }
                    this._transmitBcastRequest(seqID);
                }
                finally {
                    this.stateLock.readUnlock();
                }
            }
            catch (RWLock.IntException ex) {
                if (!this.log.isErrorEnabled()) break block6;
                this.log.error((Object)ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upBlock() {
        block5: {
            try {
                this.stateLock.writeLock();
                try {
                    this.state = 1;
                }
                finally {
                    this.stateLock.writeUnlock();
                }
            }
            catch (RWLock.IntException ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error((Object)ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _upMsg(Event event) {
        try {
            this.stateLock.readLock();
            try {
                if (this.state == -1) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Up msg in NULL_STATE");
                    }
                    boolean bl = false;
                    return bl;
                }
                Message msg = (Message)event.getArg();
                org.jgroups.Header obj = msg.getHeader(this.getName());
                if (!(obj instanceof Header)) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"No TOTAL.Header found");
                    }
                    boolean bl = false;
                    return bl;
                }
                Header header = (Header)obj;
                switch (header.type) {
                    case 2: {
                        this._recvUcast(msg);
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        this._recvBcast(msg);
                        boolean bl = false;
                        return bl;
                    }
                    case 0: {
                        this._recvBcastRequest(msg);
                        boolean bl = false;
                        return bl;
                    }
                    case 1: {
                        this._recvBcastReply(header);
                        boolean bl = false;
                        return bl;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Unknown header type");
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.stateLock.readUnlock();
            }
        }
        catch (RWLock.IntException ex) {
            if (!this.log.isErrorEnabled()) return true;
            this.log.error((Object)ex.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upSetLocalAddress(Event event) {
        block5: {
            try {
                this.stateLock.writeLock();
                try {
                    this.addr = (Address)event.getArg();
                }
                finally {
                    this.stateLock.writeUnlock();
                }
            }
            catch (RWLock.IntException ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error((Object)ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _upViewChange(Event event) {
        block7: {
            try {
                this.stateLock.writeLock();
                try {
                    this.state = 0;
                    Address oldSequencerAddr = this.sequencerAddr;
                    this.sequencerAddr = (Address)((View)event.getArg()).getMembers().elementAt(0);
                    if (this.addr.equals(this.sequencerAddr)) {
                        this.sequencerSeqID = -1L;
                        if ((oldSequencerAddr == null || !this.addr.equals(oldSequencerAddr)) && this.log.isInfoEnabled()) {
                            this.log.info((Object)"I'm the new sequencer");
                        }
                    }
                    this.seqID = -1L;
                    this._replayBcast();
                }
                finally {
                    this.stateLock.writeUnlock();
                }
            }
            catch (RWLock.IntException ex) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error((Object)ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _downBlockOk() {
        block5: {
            try {
                this.stateLock.writeLock();
                try {
                    this.state = 2;
                }
                finally {
                    this.stateLock.writeUnlock();
                }
            }
            catch (RWLock.IntException ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error((Object)ex.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _downMsg(Event event) {
        try {
            this.stateLock.readLock();
            try {
                if (this.state == -1) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Discard msg in NULL_STATE");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (this.state == 2) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Blocked, discard msg");
                    }
                    boolean bl = false;
                    return bl;
                }
                Message msg = (Message)event.getArg();
                if (msg.getDest() == null) {
                    this._sendBcastRequest(msg);
                    boolean bl = false;
                    return bl;
                }
                msg = this._sendUcast(msg);
                event.setArg(msg);
                return true;
            }
            finally {
                this.stateLock.readUnlock();
            }
        }
        catch (RWLock.IntException ex) {
            if (!this.log.isErrorEnabled()) return true;
            this.log.error((Object)ex.getMessage());
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timer;
        TimeScheduler timeScheduler = timer = this.stack != null ? this.stack.timer : null;
        if (timer == null) {
            throw new Exception("TOTAL.start(): timer is null");
        }
        this.reqTbl = new TreeMap();
        this.upTbl = new TreeMap();
        this.retransmitter = new AckSenderWindow(new Command(), this.AVG_RETRANSMIT_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        block5: {
            try {
                this.stateLock.writeLock();
                try {
                    this.state = -1;
                    this.retransmitter.reset();
                    this.reqTbl.clear();
                    this.upTbl.clear();
                    this.addr = null;
                }
                finally {
                    this.stateLock.writeUnlock();
                }
            }
            catch (RWLock.IntException ex) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error((Object)ex.getMessage());
            }
        }
    }

    private void _up(Event event) {
        switch (event.getType()) {
            case 10: {
                if (this._upBlock()) break;
                return;
            }
            case 1: {
                if (this._upMsg(event)) break;
                return;
            }
            case 8: {
                if (this._upSetLocalAddress(event)) break;
                return;
            }
            case 6: {
                if (this._upViewChange(event)) break;
                return;
            }
        }
        this.passUp(event);
    }

    private void _down(Event event) {
        switch (event.getType()) {
            case 11: {
                if (this._downBlockOk()) break;
                return;
            }
            case 1: {
                if (this._downMsg(event)) break;
                return;
            }
        }
        this.passDown(event);
    }

    public String getName() {
        return this._getName();
    }

    public boolean setProperties(Properties properties) {
        return this._setProperties(properties);
    }

    public Vector requiredDownServices() {
        return this._requiredDownServices();
    }

    public Vector requiredUpServices() {
        return this._requiredUpServices();
    }

    public void up(Event event) {
        this._up(event);
    }

    public void down(Event event) {
        this._down(event);
    }

    private class Command
    implements AckSenderWindow.RetransmitCommand {
        public void retransmit(long seqNo, Message msg) {
            TOTAL.this._retransmitBcastRequest(seqNo);
        }
    }

    public static class Header
    extends org.jgroups.Header {
        public static final int NULL_TYPE = -1;
        public static final int REQ = 0;
        public static final int REP = 1;
        public static final int UCAST = 2;
        public static final int BCAST = 3;
        public int type;
        public long localSeqID;
        public long seqID;

        public Header() {
        }

        public Header(int type, long localSeqID, long seqID) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.type = type;
                    break;
                }
                default: {
                    this.type = -1;
                    throw new IllegalArgumentException("type");
                }
            }
            this.localSeqID = localSeqID;
            this.seqID = seqID;
        }

        public String toString() {
            String typeName;
            StringBuffer buffer = new StringBuffer();
            buffer.append("[TOTAL.Header");
            switch (this.type) {
                case 0: {
                    typeName = "REQ";
                    break;
                }
                case 1: {
                    typeName = "REP";
                    break;
                }
                case 2: {
                    typeName = "UCAST";
                    break;
                }
                case 3: {
                    typeName = "BCAST";
                    break;
                }
                case -1: {
                    typeName = "NULL_TYPE";
                    break;
                }
                default: {
                    typeName = "";
                }
            }
            buffer.append(", type=" + typeName);
            buffer.append(", localID=" + this.localSeqID);
            buffer.append(", seqID=" + this.seqID);
            buffer.append(']');
            return buffer.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.localSeqID);
            out.writeLong(this.seqID);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.localSeqID = in.readLong();
            this.seqID = in.readLong();
        }
    }
}

