/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Promise;

public class ParticipantGmsImpl
extends GmsImpl {
    Vector suspected_mbrs = new Vector(11);
    Promise leave_promise = new Promise();

    public ParticipantGmsImpl(GMS g) {
        this.gms = g;
        this.suspected_mbrs.removeAllElements();
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(Address mbr) {
        Address coord;
        int max_tries = 3;
        this.leave_promise.reset();
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        while ((coord = this.gms.determineCoordinator()) != null && max_tries-- > 0) {
            if (this.gms.local_addr.equals(coord)) {
                this.gms.becomeCoordinator();
                this.gms.getImpl().handleLeave(mbr, false);
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sending LEAVE request to " + coord));
            }
            this.sendLeaveMessage(coord, mbr);
            Promise promise = this.leave_promise;
            synchronized (promise) {
                Object result = this.leave_promise.getResult(this.gms.leave_timeout);
                if (result != null) {
                    break;
                }
            }
        }
        this.gms.becomeClient();
    }

    public void handleJoinResponse(JoinRsp join_rsp) {
        this.wrongMethod("handleJoinResponse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLeaveResponse() {
        if (this.leave_promise == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"leave_promise is null");
            }
            return;
        }
        Promise promise = this.leave_promise;
        synchronized (promise) {
            this.leave_promise.setResult(Boolean.TRUE);
        }
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    public void unsuspect(Address mbr) {
        if (mbr != null) {
            this.suspected_mbrs.remove(mbr);
        }
    }

    public JoinRsp handleJoin(Address mbr) {
        this.wrongMethod("handleJoin");
        return null;
    }

    public void handleLeave(Address mbr, boolean suspected) {
        this.wrongMethod("handleLeave");
    }

    public void handleViewChange(View new_view, Digest digest) {
        Vector mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("view=" + new_view));
        }
        this.suspected_mbrs.removeAllElements();
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    public void handleSuspect(Address mbr) {
        Vector suspects = null;
        if (mbr == null) {
            return;
        }
        if (!this.suspected_mbrs.contains(mbr)) {
            this.suspected_mbrs.addElement(mbr);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("suspected mbr=" + mbr + ", suspected_mbrs=" + this.suspected_mbrs));
        }
        if (this.wouldIBeCoordinator()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("suspected mbr=" + mbr + "), members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !"));
            }
            suspects = (Vector)this.suspected_mbrs.clone();
            this.suspected_mbrs.removeAllElements();
            this.gms.becomeCoordinator();
            this.gms.castViewChange(null, null, suspects);
        }
    }

    boolean wouldIBeCoordinator() {
        Address new_coord = null;
        Vector mbrs = this.gms.members.getMembers();
        for (int i = 0; i < this.suspected_mbrs.size(); ++i) {
            mbrs.removeElement(this.suspected_mbrs.elementAt(i));
        }
        if (mbrs.size() < 1) {
            return false;
        }
        new_coord = (Address)mbrs.elementAt(0);
        return this.gms.local_addr.equals(new_coord);
    }

    void sendLeaveMessage(Address coord, Address mbr) {
        Message msg = new Message(coord, null, null);
        GMS.GmsHeader hdr = new GMS.GmsHeader(3, mbr);
        msg.putHeader(this.gms.getName(), hdr);
        this.gms.passDown(new Event(1, msg));
    }
}

