/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.blocks.MethodCall;

public class MethodCallTest
extends TestCase {
    Class cl = class$org$jgroups$tests$MethodCallTest == null ? (class$org$jgroups$tests$MethodCallTest = MethodCallTest.class$("org.jgroups.tests.MethodCallTest")) : class$org$jgroups$tests$MethodCallTest;
    static /* synthetic */ Class class$org$jgroups$tests$MethodCallTest;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public MethodCallTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public boolean foo(int a, String b) {
        System.out.println("test(" + a + ", " + b + ')');
        return true;
    }

    public void bar(String[] a, String b) {
        if (a != null) {
            for (int i = 0; i < a.length; ++i) {
                String s = a[i];
                System.out.print(s + ' ');
            }
        } else {
            System.out.println("a=null");
        }
        if (b != null) {
            System.out.println("b=" + b);
        } else {
            System.out.println("b=null");
        }
    }

    public void foobar() {
        System.out.println("foobar()");
    }

    public void testOld() {
        try {
            MethodCall mc = new MethodCall("foo", new Object[]{new Integer(22), "Bela"});
            MethodCallTest.assertEquals((Object)mc.invoke((Object)this), (Object)Boolean.TRUE);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testOld2() {
        try {
            MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, "Bela"});
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testWithNull() {
        try {
            MethodCall mc = new MethodCall("foobar", null, (Class[])null);
            System.out.println("mc: " + mc);
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testOldWithNull() {
        try {
            MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, null});
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testOldWithNull2() {
        try {
            MethodCall mc = new MethodCall("bar", new Object[]{null, "Bela"});
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testOldWithNull3() {
        try {
            MethodCall mc = new MethodCall("foobar", null);
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testOldWithNull4() {
        try {
            MethodCall mc = new MethodCall("foobar", new Object[0]);
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testMethod() {
        try {
            Method m = this.cl.getMethod("foo", Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = MethodCallTest.class$("java.lang.String")) : class$java$lang$String);
            MethodCall mc = new MethodCall(m, new Object[]{new Integer(22), "Bela"});
            MethodCallTest.assertEquals((Object)mc.invoke((Object)this), (Object)Boolean.TRUE);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testTypes() {
        MethodCall mc = new MethodCall("foo", new Object[]{new Integer(35), "Bela"}, new Class[]{Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = MethodCallTest.class$("java.lang.String")) : class$java$lang$String});
        try {
            MethodCallTest.assertEquals((Object)mc.invoke((Object)this), (Object)Boolean.TRUE);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testTypesWithArray() {
        MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, "Bela"}, new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = MethodCallTest.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$lang$String == null ? (class$java$lang$String = MethodCallTest.class$("java.lang.String")) : class$java$lang$String});
        try {
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testTypesWithNullArgument() {
        MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, null}, new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = MethodCallTest.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$lang$String == null ? (class$java$lang$String = MethodCallTest.class$("java.lang.String")) : class$java$lang$String});
        try {
            mc.invoke((Object)this);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testTypesWithNullArgument2() {
        MethodCall mc = new MethodCall("bar", new Object[]{new String[]{"one", "two", "three"}, new Object[0]}, new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = MethodCallTest.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$lang$String == null ? (class$java$lang$String = MethodCallTest.class$("java.lang.String")) : class$java$lang$String});
        try {
            mc.invoke((Object)this);
        }
        catch (IllegalArgumentException ex) {
            MethodCallTest.assertTrue((String)"this was expected", (boolean)true);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testTypesWithNullArgument3() {
        MethodCall mc = new MethodCall("foobar", new Object[0], new Class[0]);
        try {
            mc.invoke((Object)this);
        }
        catch (IllegalArgumentException ex) {
            MethodCallTest.assertTrue((String)"this was expected", (boolean)true);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testTypesWithNullArgument4() {
        MethodCall mc = new MethodCall("foobar", (Object[])null, (Class[])null);
        try {
            mc.invoke((Object)this);
        }
        catch (IllegalArgumentException ex) {
            MethodCallTest.assertTrue((String)"this was expected", (boolean)true);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testTypesWithNullArgument5() {
        MethodCall mc = new MethodCall("foobar", new Object[0], new Class[0]);
        try {
            mc.invoke((Object)this);
        }
        catch (IllegalArgumentException ex) {
            MethodCallTest.assertTrue((String)"this was expected", (boolean)true);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testSignature() {
        MethodCall mc = new MethodCall("foo", new Object[]{new Integer(35), "Bela"}, new String[]{Integer.TYPE.getName(), (class$java$lang$String == null ? (class$java$lang$String = MethodCallTest.class$("java.lang.String")) : class$java$lang$String).getName()});
        try {
            MethodCallTest.assertEquals((Object)mc.invoke((Object)this), (Object)Boolean.TRUE);
        }
        catch (Throwable t) {
            MethodCallTest.fail((String)t.toString());
        }
    }

    public void testBufferSize() throws Exception {
        int a = 10;
        String b = "Bela";
        MethodCall m = new MethodCall("foo", new Object[]{new Integer(a), b}, new Class[]{Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = MethodCallTest.class$("java.lang.String")) : class$java$lang$String});
        ByteArrayOutputStream msg_data = new ByteArrayOutputStream();
        ObjectOutputStream msg_out = new ObjectOutputStream(msg_data);
        m.writeExternal(msg_out);
        msg_out.flush();
        msg_out.close();
        byte[] data = msg_data.toByteArray();
        ByteArrayInputStream msg_in_data = new ByteArrayInputStream(data);
        ObjectInputStream msg_in = new ObjectInputStream(msg_in_data);
        MethodCall m2 = new MethodCall();
        m2.readExternal(msg_in);
        System.out.println(m2.getName());
        System.out.println(m2.getArgs().length);
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$MethodCallTest == null ? (class$org$jgroups$tests$MethodCallTest = MethodCallTest.class$("org.jgroups.tests.MethodCallTest")) : class$org$jgroups$tests$MethodCallTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MethodCallTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

