/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http;

import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import lv.ctco.cukes.core.CukesRuntimeException;

public enum HttpMethod {
    GET,
    POST,
    PUT,
    DELETE,
    OPTIONS,
    HEAD,
    PATCH;


    public static HttpMethod parse(String string) {
        for (HttpMethod httpMethod : HttpMethod.values()) {
            if (!httpMethod.toString().equalsIgnoreCase(string)) continue;
            return httpMethod;
        }
        throw new IllegalArgumentException();
    }

    public Response doRequest(RequestSpecification when) {
        return this.doRequest(when, "");
    }

    public Response doRequest(RequestSpecification when, String url) {
        switch (this) {
            case GET: {
                return (Response)when.get(url, new Object[0]);
            }
            case POST: {
                return (Response)when.post(url, new Object[0]);
            }
            case PUT: {
                return (Response)when.put(url, new Object[0]);
            }
            case DELETE: {
                return (Response)when.delete(url, new Object[0]);
            }
            case OPTIONS: {
                return (Response)when.options(url, new Object[0]);
            }
            case HEAD: {
                return (Response)when.head(url, new Object[0]);
            }
            case PATCH: {
                return (Response)when.patch(url, new Object[0]);
            }
        }
        throw new CukesRuntimeException("This Http Method is nos supported");
    }
}

