/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.restassured.config.DecoderConfig;
import io.restassured.config.JsonConfig;
import io.restassured.config.LogConfig;
import io.restassured.config.RedirectConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.config.SSLConfig;
import io.restassured.path.json.config.JsonPathConfig;
import java.io.PrintStream;
import lv.ctco.cukes.core.internal.context.GlobalWorldFacade;

@Singleton
public class RestAssuredConfiguration {
    @Inject
    GlobalWorldFacade world;
    private RestAssuredConfig restAssuredConfig;
    private PrintStream logStream;

    public RestAssuredConfig getConfig() {
        if (this.restAssuredConfig == null) {
            this.restAssuredConfig = this.buildRestAssuredConfig();
        }
        return this.restAssuredConfig;
    }

    private RestAssuredConfig buildRestAssuredConfig() {
        RestAssuredConfig config = RestAssuredConfig.newConfig().jsonConfig(JsonConfig.jsonConfig().numberReturnType(JsonPathConfig.NumberReturnType.BIG_DECIMAL)).redirect(RedirectConfig.redirectConfig().followRedirects(this.world.getBoolean("follow_redirects", true)));
        if (this.logStream != null) {
            config = config.logConfig(LogConfig.logConfig().defaultStream(this.logStream));
        }
        if (!this.world.getBoolean("gzip_support", true)) {
            config = config.decoderConfig(DecoderConfig.decoderConfig().contentDecoders(DecoderConfig.ContentDecoder.DEFLATE, new DecoderConfig.ContentDecoder[0]));
        }
        config = config.sslConfig(new SSLConfig().allowAllHostnames());
        return config;
    }

    public void setDefaultStream(PrintStream logStream) {
        this.logStream = logStream;
    }

    public void reset() {
        this.restAssuredConfig = null;
    }
}

