/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import cucumber.api.java.en.Given;
import io.restassured.http.ContentType;
import lv.ctco.cukes.http.facade.HttpRequestFacade;

@Singleton
public class GivenSteps {
    @Inject
    HttpRequestFacade facade;

    @Given(value="^baseUri is \"(.+)\"$")
    public void base_Uri_Is(String url) {
        this.facade.baseUri(url);
    }

    @Given(value="^proxy settings are \"(http|https)://([^:]+)(?::(\\d+))?\"$")
    public void proxy(String scheme, String host, Integer port) {
        this.facade.proxy(scheme, host, port);
    }

    @Given(value="^param \"(.+)\" \"(.+)\"$")
    public void param(String key, String value) {
        this.facade.param(key, value);
    }

    @Given(value="^accept \"(.+)\" mediaTypes$")
    public void accept(String mediaTypes) {
        this.facade.accept(mediaTypes);
    }

    @Given(value="^accept mediaType is JSON$")
    public void acceptJson() {
        this.facade.accept(ContentType.JSON.toString());
    }

    @Given(value="^content type is JSON$")
    public void content_Type_Json() {
        this.facade.contentType(ContentType.JSON.toString());
    }

    @Given(value="^content type is \"(.+)\"$")
    public void content_Type(String contentType) {
        this.facade.contentType(contentType);
    }

    @Given(value="^queryParam \"(.+)\" is \"(.+)\"$")
    public void query_Param(String key, String value) {
        this.facade.queryParam(key, value);
    }

    @Given(value="^session ID is \"(.+)\"$")
    public void session_ID(String sessionId) {
        this.facade.sessionId(sessionId);
    }

    @Given(value="^session ID \"(.+)\" with value \"(.+)\"$")
    public void session_ID_With_Value(String sessionId, String value) {
        this.facade.sessionId(sessionId, value);
    }

    @Given(value="^cookie \"(.+)\" with value \"(.+)\"$")
    public void cookie_With_Value(String cookie, String value) {
        this.facade.cookie(cookie, value);
    }

    @Given(value="^header ([^\"]+) with value \"(.+)\"$")
    public void header_With_Value(String name, String value) {
        this.facade.header(name, value);
    }

    @Given(value="^username \"(.+)\" and password \"(.+)\"$")
    public void authentication(String username, String password) {
        this.facade.authentication(username, password);
    }

    @Given(value="^authentication type is \"(.+)\"$")
    public void authentication(String authenticationType) {
        this.facade.authenticationType(authenticationType);
    }
}

