/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.facade;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import lv.ctco.cukes.core.internal.context.GlobalWorldFacade;
import lv.ctco.cukes.core.internal.context.InflateContext;
import lv.ctco.cukes.core.internal.matchers.ArrayWithSizeMatcher;
import lv.ctco.cukes.core.internal.matchers.ContainsPattern;
import lv.ctco.cukes.core.internal.matchers.EndsWithRegexp;
import lv.ctco.cukes.core.internal.matchers.EqualToIgnoringTypeMatcher;
import lv.ctco.cukes.core.internal.matchers.JsonMatchers;
import lv.ctco.cukes.core.internal.matchers.MiscMatchers;
import lv.ctco.cukes.core.internal.matchers.OfTypeMatcher;
import lv.ctco.cukes.core.internal.switches.SwitchedBy;
import lv.ctco.cukes.http.facade.HttpAssertionFacade;
import lv.ctco.cukes.http.facade.HttpResponseFacade;
import lv.ctco.cukes.http.facade.ResponseContentProvider;
import lv.ctco.cukes.http.json.JsonParser;
import lv.ctco.cukes.http.matchers.StatusCodeMatcher;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@Singleton
@SwitchedBy(value="assertions_disabled")
@InflateContext
public class HttpAssertionFacadeImpl
implements HttpAssertionFacade {
    @Inject
    private GlobalWorldFacade world;
    @Inject
    private JsonParser jsonParser;
    @Inject
    HttpResponseFacade facade;

    private String getPath(String path) {
        if (!StringUtils.isEmpty((CharSequence)this.facade.getResponsePrefix())) {
            return this.facade.getResponsePrefix() + path;
        }
        return path;
    }

    @Override
    public void bodyEqualTo(String body) {
        ((ValidatableResponse)this.facade.response().then()).body(Matchers.equalTo((Object)body), new Matcher[0]);
    }

    @Override
    public void bodyNotEqualTo(String body) {
        ((ValidatableResponse)this.facade.response().then()).body(Matchers.not((Matcher)Matchers.equalTo((Object)body)), new Matcher[0]);
    }

    @Override
    public void bodyNotEmpty() {
        ((ValidatableResponse)this.facade.response().then()).body(Matchers.not((Matcher)Matchers.isEmptyOrNullString()), new Matcher[0]);
    }

    @Override
    public void bodyContains(String body) {
        ((ValidatableResponse)this.facade.response().then()).body(Matchers.containsString((String)body), new Matcher[0]);
    }

    @Override
    public void bodyDoesNotContain(String body) {
        ((ValidatableResponse)this.facade.response().then()).body(Matchers.not((Matcher)Matchers.containsString((String)body)), new Matcher[0]);
    }

    @Override
    public void headerIsEmpty(String headerName) {
        ((ValidatableResponse)this.facade.response().then()).header(headerName, Matchers.isEmptyString());
    }

    @Override
    public void headerIsNotEmpty(String headerName) {
        ((ValidatableResponse)this.facade.response().then()).header(headerName, Matchers.not((Matcher)Matchers.isEmptyString()));
    }

    @Override
    public void statusCodeIs(int statusCode) {
        boolean appendBody = this.world.getBoolean("asserts.status_code.display_body", false);
        Integer maxSize = (Integer)this.world.get("asserts.status_code.max_size").transform((Function)new Function<String, Integer>(){

            public Integer apply(String s) {
                return Integer.parseInt(s);
            }
        }).orNull();
        Response response = this.facade.response();
        ((ValidatableResponse)response.then()).statusCode((Matcher)new StatusCodeMatcher(statusCode, response, appendBody, maxSize));
    }

    @Override
    public void statusCodeIsNot(int statusCode) {
        ((ValidatableResponse)this.facade.response().then()).statusCode(Matchers.not((Object)statusCode));
    }

    @Override
    public void headerEndsWith(String headerName, String suffix) {
        ((ValidatableResponse)this.facade.response().then()).header(headerName, EndsWithRegexp.endsWithRegexp((String)suffix));
    }

    @Override
    public void varAssignedFromHeader(@InflateContext.Ignore String varName, String headerName) {
        String value = this.facade.response().getHeader(headerName);
        this.world.put(varName, value);
    }

    @Override
    public void headerEqualTo(String headerName, String value) {
        ((ValidatableResponse)this.facade.response().then()).header(headerName, Matchers.equalTo((Object)value));
    }

    @Override
    public void headerNotEqualTo(String headerName, String value) {
        ((ValidatableResponse)this.facade.response().then()).header(headerName, Matchers.not((Matcher)Matchers.equalTo((Object)value)));
    }

    @Override
    public void headerContains(String headerName, String text) {
        ((ValidatableResponse)this.facade.response().then()).header(headerName, Matchers.containsString((String)text));
    }

    @Override
    public void headerDoesNotContain(String headerName, String text) {
        ((ValidatableResponse)this.facade.response().then()).header(headerName, Matchers.not((Matcher)Matchers.containsString((String)text)));
    }

    @Override
    public void bodyContainsPropertiesFromJson(String json) {
        Map<String, String> stringStringMap = this.jsonParser.parsePathToValueMap(json);
        for (Map.Entry<String, String> entry : stringStringMap.entrySet()) {
            this.bodyContainsPathWithValue(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void bodyContainsPathWithValue(String path, String value) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)EqualToIgnoringTypeMatcher.equalToIgnoringType((String)value, (boolean)this.world.getBoolean("case-insensitive"))));
    }

    @Override
    public void bodyContainsPathWithOtherValue(String path, String value) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)EqualToIgnoringTypeMatcher.notEqualToIgnoringType((String)value)));
    }

    @Override
    public void bodyDoesNotContainPath(String path) {
        Object value = this.facade.response().body().path(this.getPath(path), new String[0]);
        Assert.assertThat((Object)value, (Matcher)Matchers.nullValue());
    }

    @Override
    public void bodyContainsArrayWithSize(String path, String size) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)ArrayWithSizeMatcher.arrayWithSize((String)size)));
    }

    @Override
    public void bodyContainsPathOfType(String path, String type) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)OfTypeMatcher.ofType((String)type)));
    }

    @Override
    public void bodyContainsPathMatchingPattern(String path, String pattern) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)MiscMatchers.that((Matcher)ContainsPattern.containsPattern((String)pattern))));
    }

    @Override
    public void bodyContainsPathNotMatchingPattern(String path, String pattern) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)MiscMatchers.that((Matcher)Matchers.not((Matcher)ContainsPattern.containsPattern((String)pattern)))));
    }

    @Override
    public void varAssignedFromProperty(@InflateContext.Ignore String varName, String property) {
        String value = String.valueOf(this.facade.response().body().path(this.getPath(property), new String[0]));
        this.world.put(varName, value);
    }

    @Override
    public void varAssignedFromBody(@InflateContext.Ignore String varName) {
        String value = this.facade.response().body().asString();
        this.world.put(varName, value);
    }

    @Override
    public void bodyContainsJsonPathValueContainingPhrase(String path, String phrase) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)Matchers.containsString((String)phrase)));
    }

    @Override
    public void failureOccurs(String exceptionClass) {
        Assert.assertThat((Object)this.facade.getException().getClass().getSimpleName(), (Matcher)Matchers.is((Object)exceptionClass));
    }

    @Override
    public void failureIsExpected() {
        this.facade.setExpectException(true);
    }

    @Override
    public void bodyContainsArrayWithEntryHavingValue(String path, String value) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsValueByPathInArray((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (Matcher)EqualToIgnoringTypeMatcher.equalToIgnoringType((String)value, (boolean)this.world.getBoolean("case-insensitive"))));
    }

    @Override
    public void bodyContainsArrayWithObjectHavingProperty(String path, String property, String value) {
        Response response = this.facade.response();
        Assert.assertThat((Object)response, (Matcher)JsonMatchers.containsPropertyValueByPathInArray((JsonMatchers.ContentProvider)ResponseContentProvider.INSTANCE, (String)this.getPath(path), (String)property, (Matcher)EqualToIgnoringTypeMatcher.equalToIgnoringType((String)value, (boolean)this.world.getBoolean("case-insensitive"))));
    }
}

