/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.facade;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.specification.RequestSpecification;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import lv.ctco.cukes.core.CukesRuntimeException;
import lv.ctco.cukes.core.internal.context.GlobalWorldFacade;
import lv.ctco.cukes.core.internal.context.InflateContext;
import lv.ctco.cukes.core.internal.helpers.Time;
import lv.ctco.cukes.core.internal.matchers.EqualToIgnoringTypeMatcher;
import lv.ctco.cukes.http.AwaitCondition;
import lv.ctco.cukes.http.RestAssuredConfiguration;
import lv.ctco.cukes.http.https.TrustAllTrustManager;
import lv.ctco.cukes.http.matchers.ResponseMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@Singleton
@InflateContext
public class HttpRequestFacade {
    @Inject
    protected GlobalWorldFacade world;
    @Inject
    protected RestAssuredConfiguration restConfig;
    protected RequestSpecification specification;
    private AwaitCondition awaitCondition;

    @Inject
    public HttpRequestFacade(GlobalWorldFacade world, RestAssuredConfiguration restConfig) {
        this.world = world;
        this.restConfig = restConfig;
        this.initNewSpecification();
    }

    private void onCreate() {
        Optional $proxy;
        Optional $baseUri = this.world.get("base_uri");
        if ($baseUri.isPresent()) {
            this.baseUri((String)$baseUri.get());
        }
        if (($proxy = this.world.get("proxy")).isPresent()) {
            try {
                URI uri = new URI((String)$proxy.get());
                this.specification.proxy(uri);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        boolean urlEncodingEnabled = this.world.getBoolean("url_encoding_enabled");
        this.specification.urlEncodingEnabled(urlEncodingEnabled);
        boolean relaxedHttps = this.world.getBoolean("relaxed_https");
        if (relaxedHttps) {
            this.specification.relaxedHTTPSValidation();
            TrustAllTrustManager.trustAllHttpsCertificates();
        }
    }

    public void initNewSpecification() {
        try {
            this.specification = RestAssured.given().config(this.restConfig.getConfig());
            this.awaitCondition = null;
            this.onCreate();
        }
        catch (Exception e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public void param(String key, Object value) {
        this.specification.param(key, new Object[]{value});
    }

    public void queryParam(String parameterName, String parameterValue) {
        try {
            parameterValue = URLEncoder.encode(parameterValue, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!parameterValue.equalsIgnoreCase("null")) {
            this.specification.queryParam(parameterName, new Object[]{parameterValue});
        }
    }

    public void accept(String mediaTypes) {
        this.specification.accept(mediaTypes);
    }

    public void baseUri(String baseUri) {
        this.world.put("base_uri", baseUri);
        this.specification.baseUri(baseUri);
    }

    public void contentType(String contentType) {
        this.specification.contentType(contentType);
    }

    public void cookie(String cookieName, String cookieValue) {
        this.specification.cookie(cookieName, (Object)cookieValue, new Object[0]);
    }

    public void header(String headerName, String headerValue) {
        this.specification.header(headerName, (Object)headerValue, new Object[0]);
    }

    public void proxy(String scheme, String host, Integer port) {
        if (port == null) {
            port = 80;
        }
        this.specification.proxy(host, port.intValue(), scheme);
    }

    public void sessionId(String sessionIdValue) {
        this.specification.sessionId(sessionIdValue);
    }

    public void sessionId(String sessionIdName, String sessionIdValue) {
        this.specification.sessionId(sessionIdName, sessionIdValue);
    }

    public void filter(Filter filter) {
        this.specification.filter(filter);
    }

    public void filters(List<Filter> filters) {
        this.specification.filters(filters);
    }

    public void authentication(String username, String password) {
        this.world.put("username", username);
        this.world.put("password", password);
    }

    public void basicAuthentication(String username, String password) {
        this.specification.auth().preemptive().basic(username, password);
    }

    public void authenticationType(String authenticationType) {
        this.world.put("auth_type", authenticationType);
    }

    public RequestSpecification value() {
        return this.specification;
    }

    public void shouldWaitWithIntervalUntilStatusCodeReceived(Time waitTime, Time interval, int sCode) {
        this.awaitCondition = new AwaitCondition(waitTime, interval, ResponseMatcher.aStatusCode((Matcher<Integer>)Matchers.equalTo((Object)sCode)));
    }

    public void shouldWaitWithIntervalUntilStatusCodeReceived(Time waitTime, Time interval, int sCode, int failCode) {
        this.awaitCondition = new AwaitCondition(waitTime, interval, ResponseMatcher.aStatusCode((Matcher<Integer>)Matchers.equalTo((Object)sCode)), ResponseMatcher.aStatusCode((Matcher<Integer>)Matchers.equalTo((Object)failCode)));
    }

    public void shouldWaitWithIntervalUntilPropertyEqualToValue(Time waitTime, Time interval, String property, String value) {
        this.awaitCondition = new AwaitCondition(waitTime, interval, ResponseMatcher.aProperty(property, EqualToIgnoringTypeMatcher.equalToIgnoringType((String)value, (boolean)this.world.getBoolean("case-insensitive"))));
    }

    public void shouldWaitWithIntervalUntilPropertyEqualToValue(Time waitTime, Time interval, String property, String value, String failValue) {
        this.awaitCondition = new AwaitCondition(waitTime, interval, ResponseMatcher.aProperty(property, EqualToIgnoringTypeMatcher.equalToIgnoringType((String)value, (boolean)this.world.getBoolean("case-insensitive"))), ResponseMatcher.aProperty(property, EqualToIgnoringTypeMatcher.equalToIgnoringType((String)failValue, (boolean)this.world.getBoolean("case-insensitive"))));
    }

    public void shouldWaitWithIntervalUntilHeaderEqualToValue(Time waitTime, Time interval, String header, String value) {
        this.awaitCondition = new AwaitCondition(waitTime, interval, ResponseMatcher.aHeader(header, Matchers.equalTo((Object)value)));
    }

    public void shouldWaitWithIntervalUntilHeaderEqualToValue(Time waitTime, Time interval, String header, String value, String failValue) {
        this.awaitCondition = new AwaitCondition(waitTime, interval, ResponseMatcher.aHeader(header, Matchers.equalTo((Object)value)), ResponseMatcher.aHeader(header, Matchers.equalTo((Object)failValue)));
    }

    public AwaitCondition awaitCondition() {
        return this.awaitCondition;
    }
}

