/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.facade;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jayway.awaitility.Awaitility;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import lv.ctco.cukes.core.internal.context.GlobalWorldFacade;
import lv.ctco.cukes.core.internal.context.InflateContext;
import lv.ctco.cukes.http.AwaitCondition;
import lv.ctco.cukes.http.HttpMethod;
import lv.ctco.cukes.http.extension.CukesHttpPlugin;
import lv.ctco.cukes.http.facade.HttpRequestFacade;
import lv.ctco.cukes.http.matchers.AwaitConditionMatcher;
import org.hamcrest.Matcher;

@Singleton
@InflateContext
public class HttpResponseFacade {
    @Inject
    HttpRequestFacade specification;
    @Inject
    GlobalWorldFacade world;
    @Inject
    Set<CukesHttpPlugin> pluginSet;
    private Response response;
    private boolean expectException;
    private RuntimeException exception;
    private String responsePrefix;

    public void doRequest(String httpMethod, String url) throws Exception {
        HttpMethod method = HttpMethod.parse(httpMethod);
        boolean filterEnabled = this.world.getBoolean("loadrunner_filter_blocks_requests");
        AwaitCondition awaitCondition = this.specification.awaitCondition();
        try {
            if (awaitCondition != null && !filterEnabled) {
                int intervalTime = awaitCondition.getInterval().getValue();
                TimeUnit intervalUnit = awaitCondition.getInterval().getUnitDict().getTimeUnit();
                int waitTime = awaitCondition.getWaitTime().getValue();
                TimeUnit unit = awaitCondition.getWaitTime().getUnitDict().getTimeUnit();
                Awaitility.with().pollInterval((long)intervalTime, intervalUnit).await().atMost((long)waitTime, unit).until(this.doRequest(url, method), (Matcher)new AwaitConditionMatcher(awaitCondition));
            } else {
                this.doRequest(url, method).call();
            }
        }
        catch (RuntimeException e) {
            if (!this.expectException) {
                throw e;
            }
            this.exception = e;
        }
        this.specification.initNewSpecification();
    }

    private void authenticate() {
        Optional $type = this.world.get("auth_type");
        if (!$type.isPresent()) {
            return;
        }
        if (((String)$type.get()).equalsIgnoreCase("BASIC")) {
            this.authBasic();
        }
    }

    private Callable<Response> doRequest(String url, HttpMethod method) {
        boolean filterEnabled = this.world.getBoolean("loadrunner_filter_blocks_requests");
        return () -> {
            this.authenticate();
            RequestSpecification requestSpec = this.specification.value();
            for (CukesHttpPlugin plugin : this.pluginSet) {
                plugin.beforeRequest(requestSpec);
            }
            this.response = method.doRequest(requestSpec, url);
            for (CukesHttpPlugin plugin : this.pluginSet) {
                plugin.afterRequest(this.response);
            }
            if (!filterEnabled) {
                this.cacheHeaders(this.response);
            }
            return this.response;
        };
    }

    public Response response() {
        return this.response;
    }

    private void authBasic() {
        Optional $username = this.world.get("username");
        Optional $password = this.world.get("password");
        if ($username.isPresent() && $password.isPresent()) {
            this.specification.basicAuthentication((String)$username.get(), (String)$password.get());
        }
    }

    public void setExpectException(boolean expectException) {
        this.expectException = expectException;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public void setException(RuntimeException exception) {
        this.exception = exception;
    }

    public String getResponsePrefix() {
        return this.responsePrefix;
    }

    public void setResponsePrefix(String responsePrefix) {
        this.responsePrefix = responsePrefix;
    }

    private void cacheHeaders(Response response) {
        this.clearOldHeaders();
        Headers headers = response.getHeaders();
        for (Header header : headers) {
            String headerName = "header." + header.getName();
            this.world.put(headerName, header.getValue());
        }
    }

    private void clearOldHeaders() {
        Set keys = this.world.getKeysStartingWith("header.");
        for (String key : keys) {
            this.world.remove(key);
        }
    }
}

