/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.json;

import com.google.gson.stream.JsonToken;
import java.util.HashMap;
import java.util.Map;
import lv.ctco.cukes.http.json.SafeJsonReader;

public class JsonParser {
    public Map<String, String> parsePathToValueMap(String json) {
        HashMap<String, String> result = new HashMap<String, String>();
        SafeJsonReader reader = new SafeJsonReader(json);
        for (JsonToken token : reader) {
            if (JsonToken.BEGIN_ARRAY == token) {
                reader.beginArray();
                continue;
            }
            if (JsonToken.END_ARRAY == token) {
                reader.endArray();
                continue;
            }
            if (JsonToken.BEGIN_OBJECT == token) {
                reader.beginObject();
                continue;
            }
            if (JsonToken.END_OBJECT == token) {
                reader.endObject();
                continue;
            }
            if (JsonToken.NAME == token) {
                reader.nextName();
                continue;
            }
            if (JsonToken.STRING == token) {
                JsonParser.add(reader.getCurrentPath(), reader.nextString(), result);
                continue;
            }
            if (JsonToken.NUMBER == token) {
                JsonParser.add(reader.getCurrentPath(), reader.nextString(), result);
                continue;
            }
            if (JsonToken.BOOLEAN == token) {
                JsonParser.add(reader.getCurrentPath(), Boolean.toString(reader.nextBoolean()), result);
                continue;
            }
            if (JsonToken.NULL != token) continue;
            reader.nextNull();
        }
        reader.close();
        return result;
    }

    private static void add(String path, String value, Map<String, String> result) {
        path = path.startsWith("$.") ? path.substring(2) : path.substring(1);
        result.put(path, value);
    }
}

