/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import lv.ctco.cukes.core.CukesRuntimeException;

public class SafeJsonReader
implements Iterable<JsonToken> {
    private JsonReader reader;
    private String currentPath;

    public SafeJsonReader(String json) {
        this(new StringReader(json));
    }

    public SafeJsonReader(Reader reader) {
        this.reader = new JsonReader(reader);
        this.reader.setLenient(true);
    }

    public JsonToken peek() {
        try {
            return this.reader.peek();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public String getPath() {
        String path;
        this.currentPath = path = this.reader.getPath();
        return this.currentPath;
    }

    public void beginArray() {
        try {
            this.reader.beginArray();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public void endArray() {
        try {
            this.reader.endArray();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public void beginObject() {
        try {
            this.reader.beginObject();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public void endObject() {
        try {
            this.reader.endObject();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public void nextName() {
        try {
            this.reader.nextName();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public void nextNull() {
        try {
            this.reader.nextNull();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public String nextString() {
        try {
            return this.reader.nextString();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public boolean nextBoolean() {
        try {
            return this.reader.nextBoolean();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new CukesRuntimeException((Throwable)e);
        }
    }

    @Override
    public Iterator<JsonToken> iterator() {
        return new Iterator<JsonToken>(){

            @Override
            public boolean hasNext() {
                JsonToken token = SafeJsonReader.this.peek();
                return token != JsonToken.END_DOCUMENT;
            }

            @Override
            public JsonToken next() {
                SafeJsonReader.this.getPath();
                return SafeJsonReader.this.peek();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

