/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.logging;

import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.restassured.filter.log.LogDetail;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.response.ValidatableResponseLogSpec;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.RequestLogSpecification;
import io.restassured.specification.RequestSpecification;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lv.ctco.cukes.core.extension.CukesPlugin;
import lv.ctco.cukes.core.internal.context.GlobalWorldFacade;
import lv.ctco.cukes.http.RestAssuredConfiguration;
import lv.ctco.cukes.http.extension.CukesHttpPlugin;
import lv.ctco.cukes.http.logging.LoggerPrintStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class HttpLoggingPlugin
implements CukesHttpPlugin,
CukesPlugin {
    private static final String DEFAULT_LOGGER_NAME = "lv.ctco.cukes.http";
    private static final String DEFAULT_REQUEST_INCLUDES = "";
    private static final String DEFAULT_RESPONSE_INCLUDES = "";
    private final PrintStream logStream;
    private RestAssuredConfiguration config;
    private final GlobalWorldFacade world;

    @Inject
    public HttpLoggingPlugin(GlobalWorldFacade world, RestAssuredConfiguration config) {
        this.world = world;
        this.config = config;
        this.logStream = new LoggerPrintStream(LoggerFactory.getLogger((String)world.get("logging.http.logger.name", DEFAULT_LOGGER_NAME)), Level.INFO);
    }

    public void beforeAllTests() {
        this.config.setDefaultStream(this.logStream);
        this.config.reset();
    }

    public void afterAllTests() {
    }

    public void beforeScenario() {
    }

    public void afterScenario() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void beforeRequest(RequestSpecification requestSpecification) {
        if (!(requestSpecification instanceof FilterableRequestSpecification)) {
            throw new IllegalArgumentException("Cannot retrieve configuration from: " + requestSpecification);
        }
        FilterableRequestSpecification filterableRequestSpecification = (FilterableRequestSpecification)requestSpecification;
        RequestLogSpecification logSpec = filterableRequestSpecification.log();
        List<LogDetail> logDetails = this.parseLogDetails(this.world.get("logging.http.requests.include", ""));
        Iterator<LogDetail> iterator = logDetails.iterator();
        while (iterator.hasNext()) {
            LogDetail detail = iterator.next();
            switch (detail) {
                case ALL: {
                    logSpec.all();
                    return;
                }
                case BODY: {
                    logSpec.body();
                    break;
                }
                case COOKIES: {
                    logSpec.cookies();
                    break;
                }
                case HEADERS: {
                    logSpec.headers();
                    break;
                }
                case METHOD: {
                    logSpec.method();
                    break;
                }
                case PARAMS: {
                    logSpec.parameters();
                    break;
                }
                case URI: {
                    logSpec.uri();
                }
            }
        }
    }

    @Override
    public void afterRequest(Response response) {
        ValidatableResponseLogSpec logSpec = ((ValidatableResponse)response.then()).log();
        List<LogDetail> logDetails = this.parseLogDetails(this.world.get("logging.http.responses.include", ""));
        for (LogDetail detail : logDetails) {
            switch (detail) {
                case ALL: {
                    logSpec.all();
                    return;
                }
                case BODY: {
                    logSpec.body();
                    break;
                }
                case COOKIES: {
                    logSpec.cookies();
                    break;
                }
                case HEADERS: {
                    logSpec.headers();
                    break;
                }
                case STATUS: {
                    logSpec.status();
                }
            }
        }
    }

    private List<LogDetail> parseLogDetails(String logDetailsString) {
        if (StringUtils.isBlank((CharSequence)logDetailsString)) {
            return Lists.newArrayList();
        }
        HashSet logDetailsStrings = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)logDetailsString));
        HashSet validLogDetailsStrings = Sets.newHashSet((Iterable)Collections2.transform((Collection)Lists.newArrayList((Object[])LogDetail.values()), logDetail -> logDetail.name().toLowerCase()));
        Collection logDetails = Collections2.transform((Collection)Sets.intersection((Set)logDetailsStrings, (Set)validLogDetailsStrings), s -> LogDetail.valueOf((String)s.toUpperCase()));
        return Lists.newArrayList(logDetails.iterator());
    }
}

