/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.matchers;

import io.restassured.response.Response;
import lv.ctco.cukes.core.internal.matchers.JsonMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class ResponseMatcher {
    public static Matcher<Response> aProperty(final String path, final Matcher<?> matcher) {
        return new TypeSafeMatcher<Response>(){

            protected boolean matchesSafely(Response response) {
                return JsonMatchers.containsValueByPath((JsonMatchers.ContentProvider)new JsonMatchers.ContentProvider<Response>(){

                    public String getValue(Object o) {
                        return ((Response)o).getBody().asString();
                    }

                    public String getContentType(Object o) {
                        return ((Response)o).getContentType();
                    }
                }, (String)path, (Matcher)matcher).matches((Object)response);
            }

            public void describeTo(Description description) {
            }

            protected void describeMismatchSafely(Response item, Description mismatchDescription) {
            }
        };
    }

    public static Matcher<Response> aHeader(final String header, final Matcher<?> matcher) {
        return new TypeSafeMatcher<Response>(){

            protected boolean matchesSafely(Response response) {
                String actualHeaderValue = response.getHeader(header);
                return matcher.matches((Object)actualHeaderValue);
            }

            public void describeTo(Description description) {
            }

            protected void describeMismatchSafely(Response item, Description mismatchDescription) {
            }
        };
    }

    public static Matcher<Response> aStatusCode(final Matcher<Integer> statusCodeMatches) {
        return new TypeSafeMatcher<Response>(){

            protected boolean matchesSafely(Response response) {
                return statusCodeMatches.matches((Object)response.statusCode());
            }

            public void describeTo(Description description) {
                description.appendText("has statusCode").appendDescriptionOf((SelfDescribing)statusCodeMatches);
            }

            protected void describeMismatchSafely(Response item, Description mismatchDescription) {
                mismatchDescription.appendText("statusCode<").appendValue((Object)(item.statusCode() + "")).appendText(">");
            }
        };
    }
}

