/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.http.matchers;

import io.restassured.response.Response;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class StatusCodeMatcher
extends TypeSafeDiagnosingMatcher<Integer> {
    private final Integer expectedStatusCode;
    private final Response response;
    private final boolean appendBody;
    private final Integer maxSize;

    public StatusCodeMatcher(Integer expectedStatusCode, Response response, boolean appendBody, Integer maxSize) {
        this.expectedStatusCode = expectedStatusCode;
        this.response = response;
        this.appendBody = appendBody;
        this.maxSize = maxSize;
    }

    protected boolean matchesSafely(Integer statusCode, Description description) {
        description.appendText(String.format("was \"%d\"", statusCode));
        if (this.appendBody) {
            String body = this.response.body().asString();
            int size = body.length();
            if (this.response.getContentType().equals("application/octet-stream")) {
                description.appendText(" with body <binary>");
            } else if (this.maxSize != null && size > this.maxSize) {
                description.appendText(" with body <exceeding max size to show>");
            } else {
                description.appendText(String.format(" with body:\n\"\"\"\n%s\n\"\"\"", body));
            }
        }
        return this.expectedStatusCode.equals(statusCode);
    }

    public void describeTo(Description description) {
        description.appendText(String.format("\"%d\"", this.expectedStatusCode));
    }
}

