/*
 * Decompiled with CFR 0.152.
 */
package lv.ctco.cukes.rest.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import cucumber.api.java.en.Given;
import lv.ctco.cukes.core.internal.resources.ResourceFileReader;
import lv.ctco.cukes.rest.facade.RestRequestFacade;

@Singleton
public class GivenSteps {
    @Inject
    RestRequestFacade facade;
    @Inject
    ResourceFileReader reader;

    @Given(value="^formParam \"(.+)\" is \"(.+)\"$")
    public void form_Param(String key, String value) {
        this.facade.formParam(key, value);
    }

    @Given(value="^request body \"(.+)\"$")
    public void request_Body(String body) {
        this.facade.setRequestBody(body);
    }

    @Given(value="^request body:$")
    public void request_Body_From_Object(String body) {
        this.facade.setRequestBody(body);
    }

    @Given(value="^request body from file \"(.+)\"$")
    public void request_Body_From_File(String path) {
        this.facade.setRequestBody(this.reader.read(path));
    }

    @Given(value="^request body from binary file \"(.+)\"$")
    public void request_Body_From_Binary_File(String path) {
        this.facade.body(this.reader.readBytes(path));
    }

    @Given(value="^request body is a multipart file \"(.+)\"$")
    public void request_Body_Is_A_Multipart_File(String path) {
        this.facade.multiPart(this.reader.readBytes(path), "file", "application/octet-stream");
    }

    @Given(value="^request body is a multipart with control \"(.+)\" from file \"(.+)\"$")
    public void request_Body_Is_A_Multipart_File_With_Control(String control, String path) {
        this.facade.multiPart(this.reader.readBytes(path), control);
    }

    @Given(value="^request body is a multipart with mime-type \"(.+)\" and control \"(.+)\" from file \"(.+)\"$")
    public void request_Body_Is_A_Multipart_File_With_Control_Of_Type(String mimeType, String control, String path) {
        this.facade.multiPart(this.reader.readBytes(path), control, mimeType);
    }

    @Given(value="^request body is a multipart string \"(.+)\" with control \"(.+)\"$")
    public void request_Body_Is_A_Multipart_String_With_Control(String contentBody, String control) {
        this.facade.multiPart(contentBody, control);
    }

    @Given(value="^request body is a multipart string \"(.+)\" with mime-type \"(.+)\" and control \"(.+)\"$")
    public void request_Body_Is_A_Multipart_String_With_Control_Of_Type(String contentBody, String mimeType, String control) {
        this.facade.multiPart(contentBody, control, mimeType);
    }
}

