/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.maven;

import java.util.List;
import java.util.stream.Collectors;
import me.snowdrop.licenses.maven.SnowdropMavenEmbedder;
import me.snowdrop.licenses.properties.GeneratorProperties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class ProjectBuildingRequestFactory {
    private final GeneratorProperties properties;
    private final SnowdropMavenEmbedder maven;

    public ProjectBuildingRequestFactory(GeneratorProperties properties, SnowdropMavenEmbedder maven) {
        this.properties = properties;
        this.maven = maven;
    }

    public ProjectBuildingRequest getProjectBuildingRequest() {
        try {
            DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
            request.setLocalRepository(this.maven.getLocalRepository());
            request.setRemoteRepositories(this.getRepositories());
            request.setResolveDependencies(true);
            request.setRepositorySession(this.maven.buildRepositorySystemSession());
            request.setSystemProperties(System.getProperties());
            request.setProcessPlugins(false);
            return request;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create project building request", e);
        }
    }

    private List<ArtifactRepository> getRepositories() {
        return this.properties.getRepositories().entrySet().stream().map(entry -> {
            try {
                return this.maven.createRepository((String)entry.getValue(), (String)entry.getKey());
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Failed to initialise repository", e);
            }
        }).collect(Collectors.toList());
    }
}

