/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.ScalaSourceMojoSupport;
import scala_maven_dependency.Context;
import scala_maven_executions.JavaMainCaller;
import util.FileUtils;

@Mojo(name="doc", requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class ScalaDocMojo
extends ScalaSourceMojoSupport
implements MavenReport {
    @Parameter(property="doctitle", defaultValue="${project.name} ${project.version} API")
    private String doctitle;
    @Parameter(defaultValue="scaladocs", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/scaladocs", required=true)
    File reportOutputDirectory;
    @Parameter(property="name", defaultValue="ScalaDocs")
    private String name;
    @Parameter(property="description", defaultValue="ScalaDoc API documentation.")
    private String description;
    @Parameter(property="maven.scaladoc.className")
    private String scaladocClassName;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala")
    private File sourceDir;
    private List<File> _sourceFiles;

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        String scalaSourceDir = FileUtils.pathOf(this.sourceDir, this.useCanonicalPath);
        this.project.addCompileSourceRoot(scalaSourceDir);
        List sources = this.project.getCompileSourceRoots();
        return this.normalize(sources);
    }

    public boolean canGenerateReport() {
        return this.findSourceFiles().size() != 0;
    }

    private List<File> findSourceFiles() {
        if (this._sourceFiles == null) {
            try {
                this._sourceFiles = this.findSourceWithFilters();
            }
            catch (Exception exc) {
                throw new RuntimeException("can't define source to process", exc);
            }
        }
        return this._sourceFiles;
    }

    public boolean isExternalReport() {
        return true;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return "ScalaDoc API documentation";
        }
        return this.description;
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return "ScalaDocs";
        }
        return this.name;
    }

    public String getOutputName() {
        return this.outputDirectory + "/index";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.project.getBasedir(), this.project.getModel().getReporting().getOutputDirectory() + "/" + this.outputDirectory).getAbsoluteFile();
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File v) {
        this.reportOutputDirectory = v != null && this.outputDirectory != null && !v.getAbsolutePath().endsWith(this.outputDirectory) ? new File(v, this.outputDirectory) : v;
    }

    @Override
    public void doExecute() throws Exception {
        this.generate(null, Locale.getDefault());
    }

    protected JavaMainCaller getScalaCommand() throws Exception {
        this.checkScalaVersion();
        Context sc = this.findScalaContext();
        JavaMainCaller jcmd = this.getEmptyScalaCommand(sc.apidocMainClassName(this.scaladocClassName));
        jcmd.addArgs(this.args);
        jcmd.addJvmArgs(this.jvmArgs);
        this.addCompilerPluginOptions(jcmd);
        TreeSet<File> paths = new TreeSet<File>();
        for (String s : this.project.getCompileClasspathElements()) {
            paths.add(new File(s));
        }
        paths.remove(new File(this.project.getBuild().getOutputDirectory()));
        this.addAdditionalDependencies(paths);
        if (!paths.isEmpty()) {
            jcmd.addOption("-classpath", FileUtils.toMultiPath(paths));
        }
        jcmd.addArgs("-doc-format:html");
        jcmd.addOption("-doc-title", this.doctitle);
        return jcmd;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            List<File> sources;
            if (!this.canGenerateReport()) {
                this.getLog().info((CharSequence)"No source files found");
                return;
            }
            File reportOutputDir = this.getReportOutputDirectory();
            if (!reportOutputDir.exists()) {
                reportOutputDir.mkdirs();
            }
            if ((sources = this.findSourceFiles()).size() > 0) {
                JavaMainCaller jcmd = this.getScalaCommand();
                jcmd.addOption("-d", reportOutputDir.getAbsolutePath());
                for (File x : sources) {
                    jcmd.addArgs(FileUtils.pathOf(x, this.useCanonicalPath));
                }
                jcmd.run(this.displayCmd);
            }
        }
        catch (RuntimeException | MavenReportException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MavenReportException("wrap: " + exc.getMessage(), exc);
        }
    }
}

