/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

final class DoubleConverter
implements Converter {
    public static final DoubleConverter INSTANCE = new DoubleConverter();

    DoubleConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Double.TYPE == cls || Double.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return c == Double.TYPE ? Double.valueOf(0.0) : null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return c == Double.TYPE ? Double.valueOf(0.0) : null;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof String) {
            String str;
            NumberFormat f = context.getNumberFormat();
            if (f != null) {
                value = f.parse((String)value);
            }
            if ((str = value.toString().trim()).length() > 0) {
                return Double.valueOf(str);
            }
            return c == Double.TYPE ? Double.valueOf(0.0) : null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : Double.NaN;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

