/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Arrays;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class In<T>
extends PathSpecification<T> {
    private static final long serialVersionUID = 1L;
    private String[] allowedValues;
    private Converter converter;

    public In(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length < 1) {
            throw new IllegalArgumentException();
        }
        this.allowedValues = httpParamValues;
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Path path = this.path(root);
        Class typeOnPath = path.getJavaType();
        return path.in(this.converter.convert(Arrays.asList(this.allowedValues), typeOnPath));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.allowedValues);
        result = 31 * result + (this.converter == null ? 0 : this.converter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        In other = (In)obj;
        if (!Arrays.equals(this.allowedValues, other.allowedValues)) {
            return false;
        }
        return !(this.converter == null ? other.converter != null : !this.converter.equals(other.converter));
    }
}

