/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.kaczmarzyk.spring.data.jpa.web.annotation.OnTypeMismatch;

public class Converter {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final Converter DEFAULT = Converter.withDateFormat("yyyy-MM-dd", OnTypeMismatch.EMPTY_RESULT);
    private String dateFormat;
    private OnTypeMismatch onTypeMismatch;

    private Converter(String dateFormat, OnTypeMismatch onTypeMismatch) {
        this.dateFormat = dateFormat;
        this.onTypeMismatch = onTypeMismatch;
    }

    public <T> T convert(String value, Class<T> expectedClass) {
        if (expectedClass.isEnum()) {
            return this.convertToEnum(value, expectedClass);
        }
        if (expectedClass.isAssignableFrom(Date.class)) {
            return (T)this.convertToDate(value);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Boolean.class, Boolean.TYPE)) {
            return (T)this.convertToBoolean(value);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Integer.class, Integer.TYPE, Long.class, Long.TYPE)) {
            return (T)this.convertToLong(value);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Float.TYPE, Float.class)) {
            return (T)this.convertToFloat(value);
        }
        if (this.isAssignableFromAnyOf(expectedClass, Double.TYPE, Double.class)) {
            return (T)this.convertToDouble(value);
        }
        if (expectedClass.isAssignableFrom(LocalDateTime.class)) {
            return (T)this.convertToLocalDateTime(value);
        }
        if (expectedClass.isAssignableFrom(LocalDate.class)) {
            return (T)this.convertToLocalDate(value);
        }
        if (expectedClass.isAssignableFrom(BigDecimal.class)) {
            return (T)this.convertToBigDecimal(value);
        }
        return (T)value;
    }

    private boolean isAssignableFromAnyOf(Class<?> expectedClass, Class<?> ... candidates) {
        for (Class<?> candidate : candidates) {
            if (!expectedClass.isAssignableFrom(candidate)) continue;
            return true;
        }
        return false;
    }

    private LocalDate convertToLocalDate(String value) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormat);
        return LocalDate.parse(value, formatter);
    }

    private LocalDateTime convertToLocalDateTime(String value) {
        if (this.dateFormat.equals(DEFAULT_DATE_FORMAT)) {
            this.dateFormat = DEFAULT_DATE_TIME_FORMAT;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormat);
        return LocalDateTime.parse(value, formatter);
    }

    private Long convertToLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception");
        }
    }

    private Double convertToDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception");
        }
    }

    private Float convertToFloat(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception");
        }
    }

    private BigDecimal convertToBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new ValueRejectedException(value, "number format exception");
        }
    }

    public <T> List<T> convert(List<String> values, Class<T> expectedClass) {
        if (expectedClass == String.class) {
            return values;
        }
        ArrayList<String> rejected = null;
        ArrayList<T> result = new ArrayList<T>();
        for (String value : values) {
            try {
                result.add(this.convert(value, expectedClass));
            }
            catch (ValueRejectedException e) {
                if (rejected == null) {
                    rejected = new ArrayList<String>();
                }
                rejected.add(e.getRejectedValue());
            }
        }
        this.onTypeMismatch.handleRejectedValues(rejected);
        return result;
    }

    private Boolean convertToBoolean(String value) {
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new ValueRejectedException(value, "unparseable boolean");
    }

    public Date convertToDate(String value) {
        try {
            return new SimpleDateFormat(this.dateFormat).parse(value);
        }
        catch (ParseException e) {
            throw new ValueRejectedException(value, "invalid date, expected format: " + this.dateFormat);
        }
    }

    private <T> T convertToEnum(String value, Class<? extends Enum<?>> enumClass) {
        for (Enum<?> enumVal : enumClass.getEnumConstants()) {
            if (!enumVal.name().equals(value)) continue;
            return (T)enumVal;
        }
        throw new ValueRejectedException(value, "could not find value " + value + " for enum class " + enumClass.getSimpleName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateFormat == null ? 0 : this.dateFormat.hashCode());
        result = 31 * result + (this.onTypeMismatch == null ? 0 : this.onTypeMismatch.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Converter other = (Converter)obj;
        if (this.dateFormat == null ? other.dateFormat != null : !this.dateFormat.equals(other.dateFormat)) {
            return false;
        }
        return this.onTypeMismatch == other.onTypeMismatch;
    }

    public String toString() {
        return "Converter [dateFormat=" + this.dateFormat + ", onTypeMismatch=" + (Object)((Object)this.onTypeMismatch) + "]";
    }

    public static Converter withDateFormat(String dateFormat, OnTypeMismatch onTypeMismatch) {
        return new Converter(dateFormat != null ? dateFormat : DEFAULT_DATE_FORMAT, onTypeMismatch);
    }

    public static Converter withTypeMismatchBehaviour(OnTypeMismatch onTypeMismatch) {
        return new Converter(DEFAULT_DATE_FORMAT, onTypeMismatch);
    }

    public static class ValueRejectedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private String rejectedValue;

        public ValueRejectedException(String rejectedValue, String message) {
            super(message);
            this.rejectedValue = rejectedValue;
        }

        public String getRejectedValue() {
            return this.rejectedValue;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.getMessage();
        }
    }

    public static class ValuesRejectedException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private Collection<String> rejectedValues;

        public ValuesRejectedException(Collection<String> rejectedValues, String message) {
            super(message);
            this.rejectedValues = rejectedValues;
        }

        public Collection<String> getRejectedValues() {
            return this.rejectedValues;
        }

        @Override
        public String toString() {
            return this.getClass() + ": " + this.getMessage();
        }
    }
}

