/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.kaczmarzyk.spring.data.jpa.utils.TypeUtil;
import net.kaczmarzyk.spring.data.jpa.web.AndSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.ConjunctionSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.DisjunctionSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.EnhancerUtil;
import net.kaczmarzyk.spring.data.jpa.web.OrSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.SimpleSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestProcessingContext;
import net.kaczmarzyk.spring.data.jpa.web.annotation.And;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Disjunction;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Or;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class AnnotatedSpecInterfaceArgumentResolver
implements HandlerMethodArgumentResolver {
    private SimpleSpecificationResolver simpleResolver = new SimpleSpecificationResolver();
    private OrSpecificationResolver orResolver = new OrSpecificationResolver();
    private DisjunctionSpecificationResolver disjunctionResolver = new DisjunctionSpecificationResolver();
    private ConjunctionSpecificationResolver conjunctionResolver = new ConjunctionSpecificationResolver();
    private AndSpecificationResolver andResolver = new AndSpecificationResolver();
    private List<Class<? extends Annotation>> annotationTypes = Arrays.asList(Spec.class, Or.class, And.class, Conjunction.class, Disjunction.class);

    AnnotatedSpecInterfaceArgumentResolver() {
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class paramType = parameter.getParameterType();
        return paramType.isInterface() && Specification.class.isAssignableFrom(paramType) && this.isAnnotated(paramType);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        WebRequestProcessingContext context = new WebRequestProcessingContext(parameter, webRequest);
        List ifaceSpecs = this.resolveSpecFromInterfaceAnnotations(context);
        Specification<Object> paramSpec = this.resolveSpecFromParameterAnnotations(context);
        if (ifaceSpecs.isEmpty() && paramSpec == null) {
            return null;
        }
        if (paramSpec != null) {
            ifaceSpecs.add(paramSpec);
        }
        net.kaczmarzyk.spring.data.jpa.domain.Conjunction<Object> spec = new net.kaczmarzyk.spring.data.jpa.domain.Conjunction<Object>(ifaceSpecs);
        return EnhancerUtil.wrapWithIfaceImplementation(parameter.getParameterType(), spec);
    }

    private Specification<Object> resolveSpecFromParameterAnnotations(WebRequestProcessingContext context) throws Exception {
        Object specDef = this.getAnnotation(context.getParameterAnnotations());
        return specDef != null ? this.buildSpecification(context, specDef) : null;
    }

    private List<Specification<Object>> resolveSpecFromInterfaceAnnotations(WebRequestProcessingContext context) {
        ArrayList<Specification<Object>> result = new ArrayList<Specification<Object>>();
        Collection<Class<?>> ifaceTree = TypeUtil.interfaceTree(context.getParameterType());
        for (Class<?> iface : ifaceTree) {
            if (!this.isAnnotated(iface)) continue;
            Object specDef = this.getAnnotation(iface);
            result.add(this.buildSpecification(context, specDef));
        }
        return result;
    }

    private Specification<Object> buildSpecification(WebRequestProcessingContext context, Object specDef) {
        Specification<Object> spec;
        if (specDef instanceof Spec) {
            spec = this.simpleResolver.buildSpecification(context, (Spec)specDef);
        } else if (specDef instanceof Or) {
            spec = this.orResolver.buildSpecification(context, (Or)specDef);
        } else if (specDef instanceof Disjunction) {
            spec = this.disjunctionResolver.buildSpecification(context, (Disjunction)specDef);
        } else if (specDef instanceof Conjunction) {
            spec = this.conjunctionResolver.buildSpecification(context, (Conjunction)specDef);
        } else if (specDef instanceof And) {
            spec = this.andResolver.buildSpecification(context, (And)specDef);
        } else {
            throw new IllegalStateException();
        }
        return spec;
    }

    private final boolean isAnnotated(Class<?> target) {
        return this.getAnnotation(target) != null;
    }

    private Object getAnnotation(Annotation[] parameterAnnotations) {
        for (Annotation annotation : parameterAnnotations) {
            for (Class<? extends Annotation> annotationType : this.annotationTypes) {
                if (!annotationType.isAssignableFrom(annotation.getClass())) continue;
                return annotation;
            }
        }
        return null;
    }

    private final Object getAnnotation(Class<?> target) {
        for (Class<? extends Annotation> annotationType : this.annotationTypes) {
            Annotation potentialAnnotation = target.getAnnotation(annotationType);
            if (potentialAnnotation == null) continue;
            return potentialAnnotation;
        }
        return null;
    }
}

