/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import net.kaczmarzyk.spring.data.jpa.web.OrSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.SimpleSpecificationResolver;
import net.kaczmarzyk.spring.data.jpa.web.WebRequestProcessingContext;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Or;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class ConjunctionSpecificationResolver
implements HandlerMethodArgumentResolver {
    private SimpleSpecificationResolver specResolver = new SimpleSpecificationResolver();
    private OrSpecificationResolver orResolver = new OrSpecificationResolver();

    ConjunctionSpecificationResolver() {
    }

    public boolean supportsParameter(MethodParameter param) {
        return param.getParameterType() == Specification.class && param.hasParameterAnnotation(Conjunction.class);
    }

    public Specification<?> resolveArgument(MethodParameter param, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Conjunction def = (Conjunction)param.getParameterAnnotation(Conjunction.class);
        WebRequestProcessingContext context = new WebRequestProcessingContext(param, webRequest);
        return this.buildSpecification(context, def);
    }

    Specification<Object> buildSpecification(WebRequestProcessingContext context, Conjunction def) {
        ArrayList innerSpecs = new ArrayList();
        for (Or or : def.value()) {
            Specification<Object> innerOr = this.orResolver.buildSpecification(context, or);
            if (innerOr == null) continue;
            innerSpecs.add(innerOr);
        }
        for (Annotation annotation : def.and()) {
            Specification<Object> innerSpec = this.specResolver.buildSpecification(context, (Spec)annotation);
            if (innerSpec == null) continue;
            innerSpecs.add(innerSpec);
        }
        return innerSpecs.isEmpty() ? null : new net.kaczmarzyk.spring.data.jpa.domain.Conjunction(innerSpecs);
    }
}

