/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kaczmarzyk.spring.data.jpa.domain.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.EnhancerUtil;
import net.kaczmarzyk.spring.data.jpa.web.MethodParameterUtil;
import net.kaczmarzyk.spring.data.jpa.web.RecursiveHandlerMethodArgumentResolver;
import net.kaczmarzyk.spring.data.jpa.web.SpecificationArgumentResolver;
import net.kaczmarzyk.spring.data.jpa.web.annotation.JoinFetch;
import org.springframework.core.MethodParameter;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

class JoinFetchSpecificationResolver
implements RecursiveHandlerMethodArgumentResolver {
    private SpecificationArgumentResolver parentResolver;

    public JoinFetchSpecificationResolver(SpecificationArgumentResolver parent) {
        this.parentResolver = parent;
    }

    public boolean supportsParameter(MethodParameter param) {
        Class paramType = param.getParameterType();
        return paramType.isInterface() && Specification.class.isAssignableFrom(paramType) && MethodParameterUtil.isAnnotatedWith(JoinFetch.class, param);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return this.resolveArgument(parameter, mavContainer, webRequest, binderFactory, new ArrayList<HandlerMethodArgumentResolver>());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, List<HandlerMethodArgumentResolver> recursiveCallers) throws Exception {
        Conjunction spec;
        recursiveCallers.add(this);
        Conjunction fetchSpec = this.resolveFetchSpec(parameter);
        Specification regularSpec = (Specification)this.parentResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory, recursiveCallers);
        Conjunction conjunction = spec = regularSpec == null ? fetchSpec : new Conjunction(Arrays.asList(fetchSpec, regularSpec));
        if (Specification.class == parameter.getParameterType()) {
            return spec;
        }
        return EnhancerUtil.wrapWithIfaceImplementation(parameter.getParameterType(), spec);
    }

    private Specification<Object> resolveFetchSpec(MethodParameter parameter) {
        if (MethodParameterUtil.isAnnotatedWith(JoinFetch.class, parameter)) {
            JoinFetch fetchDef = MethodParameterUtil.getAnnotation(JoinFetch.class, parameter);
            return this.newJoinFetch(fetchDef);
        }
        throw new IllegalArgumentException("@JoinFetch expected!");
    }

    private net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object> newJoinFetch(JoinFetch fetchDef) {
        return new net.kaczmarzyk.spring.data.jpa.domain.JoinFetch<Object>(fetchDef.paths(), fetchDef.joinType());
    }
}

