/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

public abstract class DateTimeUtils {
    public static <T> T startOfDay(Object dateObject) {
        Class<?> expectedClass = dateObject.getClass();
        if (Calendar.class.isAssignableFrom(expectedClass)) {
            return (T)DateTimeUtils.atStartOfDayFor((Calendar)dateObject);
        }
        if (LocalDateTime.class.isAssignableFrom(expectedClass)) {
            return (T)DateTimeUtils.atStartOfDayFor((LocalDateTime)dateObject);
        }
        if (LocalDate.class.isAssignableFrom(expectedClass)) {
            LocalDate date = (LocalDate)dateObject;
            return (T)LocalDate.of(date.getYear(), date.getMonth(), date.getDayOfMonth());
        }
        if (OffsetDateTime.class.isAssignableFrom(expectedClass)) {
            return (T)DateTimeUtils.atStartOfDayFor((OffsetDateTime)dateObject);
        }
        if (Instant.class.isAssignableFrom(expectedClass)) {
            return (T)((Instant)dateObject).truncatedTo(ChronoUnit.DAYS);
        }
        if (Timestamp.class.isAssignableFrom(expectedClass)) {
            Timestamp date = (Timestamp)dateObject;
            return (T)new Timestamp(date.getYear(), date.getMonth(), date.getDate(), 0, 0, 0, 0);
        }
        if (Date.class.isAssignableFrom(expectedClass)) {
            Date date = (Date)dateObject;
            return (T)new Date(date.getYear(), date.getMonth(), date.getDate());
        }
        throw new IllegalArgumentException("Could not recognize date object!");
    }

    public static <T> T startOfNextDay(Object dateObject) {
        Class<?> expectedClass = dateObject.getClass();
        if (Calendar.class.isAssignableFrom(expectedClass)) {
            Calendar startOfNextDayCalendar = DateTimeUtils.atStartOfDayFor((Calendar)dateObject);
            startOfNextDayCalendar.add(5, 1);
            return (T)startOfNextDayCalendar;
        }
        if (LocalDateTime.class.isAssignableFrom(expectedClass)) {
            return (T)DateTimeUtils.atStartOfDayFor((LocalDateTime)dateObject).plusDays(1L);
        }
        if (LocalDate.class.isAssignableFrom(expectedClass)) {
            return (T)((LocalDate)dateObject).plusDays(1L);
        }
        if (OffsetDateTime.class.isAssignableFrom(expectedClass)) {
            return (T)DateTimeUtils.atStartOfDayFor((OffsetDateTime)dateObject).plusDays(1L);
        }
        if (Instant.class.isAssignableFrom(expectedClass)) {
            return (T)((Instant)dateObject).truncatedTo(ChronoUnit.DAYS).plus(1L, ChronoUnit.DAYS);
        }
        if (Timestamp.class.isAssignableFrom(expectedClass)) {
            Timestamp date = (Timestamp)dateObject;
            LocalDateTime localDateTime = date.toLocalDateTime();
            return (T)Timestamp.valueOf(DateTimeUtils.atStartOfDayFor(localDateTime).plusDays(1L));
        }
        if (Date.class.isAssignableFrom(expectedClass)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)dateObject);
            Calendar startOfNextDayCalendar = DateTimeUtils.atStartOfDayFor(calendar);
            startOfNextDayCalendar.add(5, 1);
            return (T)startOfNextDayCalendar.getTime();
        }
        throw new IllegalArgumentException("Could not recognize date object!");
    }

    private static Calendar atStartOfDayFor(Calendar calendar) {
        Calendar startOfDayCalendar = Calendar.getInstance();
        startOfDayCalendar.setTime(calendar.getTime());
        startOfDayCalendar.set(11, 0);
        startOfDayCalendar.set(12, 0);
        startOfDayCalendar.set(13, 0);
        startOfDayCalendar.set(14, 0);
        return startOfDayCalendar;
    }

    private static LocalDateTime atStartOfDayFor(LocalDateTime date) {
        return LocalDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, 0);
    }

    private static OffsetDateTime atStartOfDayFor(OffsetDateTime date) {
        return OffsetDateTime.of(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, 0, date.getOffset());
    }
}

