/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.HandlerMapping;

public abstract class PathVariableResolver {
    public static Map<String, String> resolvePathVariables(NativeWebRequest nativeWebRequest, MethodParameter methodParameter) {
        Map pathVariables = (Map)nativeWebRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        if (Objects.nonNull(pathVariables)) {
            return pathVariables;
        }
        return PathVariableResolver.resolvePathVariables(PathVariableResolver.pathPattern(methodParameter), PathVariableResolver.actualWebPath(nativeWebRequest));
    }

    private static Map<String, String> resolvePathVariables(String pathPattern, String actualPath) {
        AntPathMatcher pathMatcher = new AntPathMatcher();
        if (pathMatcher.match(pathPattern, actualPath)) {
            return pathMatcher.extractUriTemplateVariables(pathPattern, actualPath);
        }
        return Collections.emptyMap();
    }

    private static String pathPattern(MethodParameter methodParameter) {
        String pathPattern = null;
        Class controllerClass = methodParameter.getContainingClass();
        if (controllerClass.getAnnotation(RequestMapping.class) != null) {
            RequestMapping controllerMapping = controllerClass.getAnnotation(RequestMapping.class);
            pathPattern = PathVariableResolver.firstOf(controllerMapping.value(), controllerMapping.path());
        }
        String methodPathPattern = null;
        if (methodParameter.hasMethodAnnotation(RequestMapping.class)) {
            RequestMapping methodMapping = (RequestMapping)methodParameter.getMethodAnnotation(RequestMapping.class);
            methodPathPattern = PathVariableResolver.firstOf(methodMapping.value(), methodMapping.path());
        } else if (methodParameter.hasMethodAnnotation(GetMapping.class)) {
            GetMapping methodMapping = (GetMapping)methodParameter.getMethodAnnotation(GetMapping.class);
            methodPathPattern = PathVariableResolver.firstOf(methodMapping.value(), methodMapping.path());
        }
        if (methodPathPattern != null) {
            String string = pathPattern = pathPattern != null ? pathPattern + methodPathPattern : methodPathPattern;
        }
        if (pathPattern.isEmpty()) {
            throw new IllegalStateException("path pattern could not be resolved (searched for @RequestMapping or @GetMapping)");
        }
        return pathPattern;
    }

    private static String actualWebPath(NativeWebRequest nativeWebRequest) {
        HttpServletRequest request = (HttpServletRequest)nativeWebRequest.getNativeRequest();
        return request.getPathInfo() != null ? request.getPathInfo() : request.getRequestURI().substring(request.getContextPath().length());
    }

    private static String firstOf(String[] array1, String[] array2) {
        if (array1.length > 0) {
            return array1[0];
        }
        if (array2.length > 0) {
            return array2[0];
        }
        return null;
    }
}

