/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCore;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class MalisisCommand
extends CommandBase {
    Set<String> parameters = new HashSet<String>();

    public MalisisCommand() {
        this.parameters.add("config");
        this.parameters.add("version");
    }

    public String getCommandName() {
        return "malisis";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "malisiscore.commands.usage";
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] params) throws CommandException {
        if (params.length == 0) {
            throw new WrongUsageException("malisiscore.commands.usage", new Object[0]);
        }
        if (!this.parameters.contains(params[0])) {
            throw new WrongUsageException("malisiscore.commands.usage", new Object[0]);
        }
        switch (params[0]) {
            case "config": {
                this.configCommand(sender, params);
                break;
            }
            case "version": {
                IMalisisMod mod = null;
                if (params.length == 1) {
                    mod = MalisisCore.instance;
                } else {
                    mod = MalisisCore.getMod(params[1]);
                    if (mod == null) {
                        MalisisCore.message("malisiscore.commands.modnotfound", params[1]);
                    }
                }
                if (mod == null) break;
                MalisisCore.message("malisiscore.commands.modversion", mod.getName(), mod.getVersion());
                break;
            }
            default: {
                MalisisCore.message("Not yet implemented");
            }
        }
    }

    public boolean checkPermission(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] params, BlockPos pos) {
        if (params.length == 1) {
            return MalisisCommand.getListOfStringsMatchingLastWord((String[])params, this.parameters);
        }
        if (params.length == 2) {
            return MalisisCommand.getListOfStringsMatchingLastWord((String[])params, MalisisCore.listModId());
        }
        return null;
    }

    public boolean isUsernameIndex(String[] astring, int i) {
        return false;
    }

    public void configCommand(ICommandSender sender, String[] params) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MalisisCore.log.warn("Can't open configuration GUI on a dedicated server.");
            return;
        }
        IMalisisMod mod = null;
        if (params.length == 1) {
            mod = MalisisCore.instance;
        } else {
            mod = MalisisCore.getMod(params[1]);
            if (mod == null) {
                MalisisCore.message("malisiscore.commands.modnotfound", params[1]);
            }
        }
        if (mod != null && !MalisisCore.openConfigurationGui(mod)) {
            MalisisCore.message("malisiscore.commands.noconfiguration", mod.getName());
        }
    }
}

