/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCommand;
import net.malisis.core.MalisisRegistry;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.configuration.ConfigurationGui;
import net.malisis.core.configuration.Settings;
import net.malisis.core.network.MalisisNetwork;
import net.malisis.core.util.blockdata.BlockDataHandler;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.malisis.core.util.multiblock.MultiBlock;
import net.malisis.core.util.remapping.RemappingTool;
import net.malisis.core.util.replacement.ReplacementTool;
import net.malisis.core.util.syncer.Syncer;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="malisiscore", name="Malisis Core", version="1.9-3.1.0")
public class MalisisCore
implements IMalisisMod {
    public static final int malisisRenderType = 4;
    public static final String modid = "malisiscore";
    public static final String modname = "Malisis Core";
    public static final String version = "1.9-3.1.0";
    public static final String url = "";
    public static MalisisCore instance;
    public static Logger log;
    public static MalisisNetwork network;
    private HashMap<String, IMalisisMod> registeredMods = new HashMap();
    public static boolean isObfEnv;

    public MalisisCore() {
        instance = this;
        network = new MalisisNetwork(this);
        isObfEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") == false;
    }

    @Override
    public String getModId() {
        return modid;
    }

    @Override
    public String getName() {
        return modname;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Settings getSettings() {
        return null;
    }

    public static void registerMod(IMalisisMod mod) {
        MalisisCore.instance.registeredMods.put(mod.getModId(), mod);
    }

    public static IMalisisMod getMod(String id) {
        return MalisisCore.instance.registeredMods.get(id);
    }

    public static Set<String> listModId() {
        return MalisisCore.instance.registeredMods.keySet();
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)ReplacementTool.instance());
        MinecraftForge.EVENT_BUS.register((Object)ChunkBlockHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)BlockDataHandler.get());
        MalisisNetwork.createMessages(event.getAsmData());
        Syncer.get().discover(event.getAsmData());
        MultiBlock.registerBlockData();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MalisisRegistry.registerBlockComponents();
        if (MalisisCore.isClient()) {
            ClientCommandHandler.instance.registerCommand((ICommand)new MalisisCommand());
            MalisisRegistry.registerRenderers();
        }
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        RemappingTool.processMissingMappings(event);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiClose(GuiOpenEvent event) {
        if (!MalisisGui.cancelClose || event.getGui() != null) {
            return;
        }
        MalisisGui.cancelClose = false;
        event.setCanceled(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean openConfigurationGui(IMalisisMod mod) {
        Settings settings = mod.getSettings();
        if (settings == null) {
            return false;
        }
        new ConfigurationGui(settings).display(true);
        return true;
    }

    public static void message(Object text) {
        MalisisCore.message(text, new Object[]{null});
    }

    public static void message(Object text, Object ... data) {
        if (text == null) {
            return;
        }
        String txt = text.toString();
        if (text instanceof Object[]) {
            txt = Arrays.deepToString((Object[])text);
        }
        TextComponentString msg = new TextComponentString(I18n.translateToLocalFormatted((String)txt, (Object[])data));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MinecraftServer server = FMLCommonHandler.instance().getSidedDelegate().getServer();
            if (server != null) {
                server.getPlayerList().sendChatMsg((ITextComponent)msg);
            }
        } else {
            if (Minecraft.getMinecraft() == null || Minecraft.getMinecraft().thePlayer == null) {
                return;
            }
            Style cs = new Style();
            cs.setItalic(Boolean.valueOf(true));
            cs.setColor(TextFormatting.GRAY);
            msg.setStyle(cs);
            Minecraft.getMinecraft().thePlayer.addChatMessage((ITextComponent)msg);
        }
    }

    static {
        log = LogManager.getLogger((String)modid);
        isObfEnv = false;
    }
}

