/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public interface IBoundingBox {
    public AxisAlignedBB getBoundingBox(IBlockAccess var1, BlockPos var2, IBlockState var3, BoundingBoxType var4);

    default public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        return new AxisAlignedBB[]{this.getBoundingBox(world, pos, state, type)};
    }

    default public AxisAlignedBB[] getCollisionBoundingBoxes(World world, BlockPos pos, IBlockState state) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.COLLISION);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        return aabbs;
    }

    default public void addCollisionBoxToList(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.COLLISION);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        for (AxisAlignedBB aabb : AABBUtils.offset(pos, aabbs)) {
            if (aabb == null || !mask.intersectsWith(aabb)) continue;
            list.add(aabb);
        }
    }

    default public AxisAlignedBB getSelectedBoundingBox(IBlockState state, World world, BlockPos pos) {
        Object[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.SELECTION);
        if (ArrayUtils.isEmpty((Object[])aabbs) || aabbs[0] == null) {
            return AABBUtils.empty(pos);
        }
        aabbs = AABBUtils.rotate((AxisAlignedBB[])aabbs, DirectionalComponent.getDirection((IBlockAccess)world, pos));
        return AABBUtils.offset(pos, AABBUtils.combine((AxisAlignedBB[])aabbs));
    }

    default public AxisAlignedBB[] getRenderBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes(world, pos, state, BoundingBoxType.RENDER);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        return aabbs;
    }

    default public AxisAlignedBB[] getRayTraceBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes(world, pos, state, BoundingBoxType.RAYTRACE);
        aabbs = AABBUtils.rotate(aabbs, DirectionalComponent.getDirection(state));
        return aabbs;
    }

    default public RayTraceResult collisionRayTrace(IBlockState state, World world, BlockPos pos, Vec3d src, Vec3d dest) {
        return new RaytraceBlock(world, src, dest, pos).trace();
    }
}

