/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.component.LadderComponent;
import net.malisis.core.item.MalisisItemBlock;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@MalisisRendered(value=DefaultRenderer.Block.class)
public class MalisisBlock
extends Block
implements IBoundingBox,
IRegisterable,
IComponentProvider {
    private static Field blockStateField = AsmUtils.changeFieldAccess(Block.class, "blockState", "field_176227_L");
    protected String name;
    protected AxisAlignedBB boundingBox;
    protected final List<IBlockComponent> blockComponents = Lists.newArrayList();
    protected final List<IComponent> components = Lists.newArrayList();

    protected MalisisBlock(Material material) {
        super(material);
    }

    protected List<IProperty<?>> getProperties() {
        return Lists.newArrayList();
    }

    protected void buildBlockState() {
        List<IProperty<?>> properties = this.getProperties();
        for (IBlockComponent component : this.getBlockComponents()) {
            properties.addAll(Arrays.asList(component.getProperties()));
        }
        try {
            blockStateField.set(this, new BlockStateContainer((Block)this, properties.toArray(new IProperty[0])));
        }
        catch (ReflectiveOperationException e) {
            MalisisCore.log.error("[MalisisBlock] Failed to set the new BlockState for {}.", new Object[]{this.getClass().getSimpleName(), e});
        }
    }

    private void buildDefaultState() {
        IBlockState state = this.blockState.getBaseState();
        for (IBlockComponent component : this.getBlockComponents()) {
            state = component.setDefaultState(this, state);
        }
        this.setDefaultState(state);
    }

    public List<IBlockComponent> getBlockComponents() {
        return this.blockComponents;
    }

    @Override
    public List<IComponent> getComponents() {
        return Stream.concat(this.blockComponents.stream(), this.components.stream()).collect(Collectors.toList());
    }

    @Override
    public void addComponent(IComponent component) {
        if (component.isClientComponent() && !MalisisCore.isClient()) {
            throw new IllegalStateException("Trying to add component " + component.getClass().getSimpleName() + " on server.");
        }
        if (component instanceof IBlockComponent) {
            this.blockComponents.add((IBlockComponent)component);
            for (IComponent dep : ((IBlockComponent)component).getDependencies()) {
                this.addComponent(dep);
            }
            this.buildBlockState();
            this.buildDefaultState();
        } else {
            this.components.add(component);
        }
        this.lightOpacity = this.getDefaultState().isOpaqueCube() ? 255 : 0;
    }

    public Block setName(String name) {
        this.name = name;
        this.setUnlocalizedName(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getUnlocalizedName(IBlockState state) {
        for (IBlockComponent component : this.blockComponents) {
            String name = component.getUnlocalizedName(this, state);
            if (name == null) continue;
            return name;
        }
        return this.getUnlocalizedName();
    }

    @Override
    public Item getItem(Block block) {
        for (IBlockComponent component : this.blockComponents) {
            Item item = component.getItem(this);
            if (item != null && item.getClass() == MalisisItemBlock.class) continue;
            return item;
        }
        return IRegisterable.super.getItem(this);
    }

    public void setTexture(String textureName) {
        if (!StringUtils.isEmpty((CharSequence)textureName) && MalisisCore.isClient()) {
            Icon icon = Icon.from(textureName);
            this.addComponent(() -> icon);
        }
    }

    public void setTexture(Item item) {
        if (item != null && MalisisCore.isClient()) {
            Icon icon = Icon.from(item);
            this.addComponent(() -> icon);
        }
    }

    public void setTexture(Block block) {
        if (block != null) {
            this.setTexture(block.getDefaultState());
        }
    }

    public void setTexture(IBlockState state) {
        if (state != null && MalisisCore.isClient()) {
            Icon icon = Icon.from(state);
            this.addComponent(() -> icon);
        }
    }

    public IBlockState getStateFromItemStack(ItemStack itemStack) {
        return this.getStateFromMeta(itemStack.getItem().getMetadata(itemStack.getMetadata()));
    }

    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        for (IBlockComponent component : this.getBlockComponents()) {
            state = component.onBlockPlaced(this, world, pos, state, facing, hitX, hitY, hitZ, meta, placer);
        }
        return state;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        for (IBlockComponent component : this.getBlockComponents()) {
            component.onBlockPlacedBy(this, world, pos, state, placer, stack);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean b = false;
        for (IBlockComponent component : this.getBlockComponents()) {
            b |= component.onBlockActivated(this, world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        return b;
    }

    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        for (IBlockComponent component : this.getBlockComponents()) {
            component.onNeighborBlockChange(this, world, pos, state, neighborBlock);
        }
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            component.breakBlock(this, world, pos, state);
        }
        super.breakBlock(world, pos, state);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        for (IBlockComponent component : this.getBlockComponents()) {
            AxisAlignedBB aabb = component.getBoundingBox(this, world, pos, state, type);
            if (aabb == null) continue;
            return aabb;
        }
        return FULL_BLOCK_AABB;
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        ArrayList list = Lists.newArrayList();
        for (IBlockComponent component : this.getBlockComponents()) {
            AxisAlignedBB[] aabbs = component.getBoundingBoxes(this, world, pos, state, type);
            if (aabbs == null) continue;
            list.addAll(Arrays.asList(aabbs));
        }
        return list.size() != 0 ? list.toArray(new AxisAlignedBB[0]) : IBoundingBox.super.getBoundingBoxes(world, pos, state, type);
    }

    @Override
    public void addCollisionBoxToList(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        IBoundingBox.super.addCollisionBoxToList(state, world, pos, mask, list, collidingEntity);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBox(IBlockState state, World world, BlockPos pos) {
        return IBoundingBox.super.getSelectedBoundingBox(state, world, pos);
    }

    @Override
    public RayTraceResult collisionRayTrace(IBlockState state, World world, BlockPos pos, Vec3d src, Vec3d dest) {
        return IBoundingBox.super.collisionRayTrace(state, world, pos, src, dest);
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getBlockComponents()) {
            if (component.canPlaceBlockOnSide(this, world, pos, side)) continue;
            return false;
        }
        return super.canPlaceBlockOnSide(world, pos, side);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        for (IBlockComponent component : this.getBlockComponents()) {
            if (component.canPlaceBlockAt(this, world, pos)) continue;
            return false;
        }
        return super.canPlaceBlockAt(world, pos);
    }

    public int damageDropped(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            int damage = component.damageDropped(this, state);
            if (damage == 0) continue;
            return damage;
        }
        return this.getMetaFromState(state);
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List<ItemStack> list) {
        ArrayList l = Lists.newArrayList();
        for (IBlockComponent component : this.getBlockComponents()) {
            component.getSubBlocks(this, item, tab, l);
        }
        if (l.isEmpty()) {
            super.getSubBlocks(item, tab, list);
        } else {
            list.addAll(l);
        }
    }

    public MapColor getMapColor(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            MapColor color = component.getMapColor(this, state);
            if (color == null) continue;
            return color;
        }
        return super.getMapColor(state);
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = this.getDefaultState();
        for (IBlockComponent component : this.getBlockComponents()) {
            state = component.getStateFromMeta(this, state, meta);
        }
        return state;
    }

    public int getMetaFromState(IBlockState state) {
        int meta = 0;
        for (IBlockComponent component : this.getBlockComponents()) {
            meta += component.getMetaFromState(this, state);
        }
        return meta;
    }

    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean render = component.shouldSideBeRendered(this, world, pos, state, side);
            if (render == null) continue;
            return render;
        }
        return super.shouldSideBeRendered(state, world, pos, side);
    }

    public boolean isFullBlock(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean full = component.isFullBlock(this, state);
            if (full == null) continue;
            return full;
        }
        return super.isFullBlock(state);
    }

    public boolean isFullCube(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean full = component.isFullCube(this, state);
            if (full == null) continue;
            return full;
        }
        return super.isFullCube(state);
    }

    public boolean isOpaqueCube(IBlockState state) {
        if (this.getBlockComponents() == null) {
            return super.isOpaqueCube(state);
        }
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean opaque = component.isOpaqueCube(this, state);
            if (opaque == null) continue;
            return opaque;
        }
        return super.isOpaqueCube(state);
    }

    @SideOnly(value=Side.CLIENT)
    public int getPackedLightmapCoords(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Integer light = component.getPackedLightmapCoords(this, world, pos, state);
            if (light == null) continue;
            return light;
        }
        return super.getPackedLightmapCoords(state, world, pos);
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Item item = component.getItemDropped(this, state, rand, fortune);
            if (item == null) continue;
            return item;
        }
        return super.getItemDropped(state, rand, fortune);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Integer quantity = component.quantityDropped(this, state, fortune, random);
            if (quantity == null) continue;
            return quantity;
        }
        return super.quantityDropped(state, fortune, random);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Integer quantity = component.getLightOpacity(this, world, pos, state);
            if (quantity == null) continue;
            return quantity;
        }
        return super.getLightOpacity(state, world, pos);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return IComponent.getComponent(LadderComponent.class, this) != null;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

