/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterComponent;
import net.malisis.core.item.MalisisItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorComponent
implements IBlockComponent,
IRegisterComponent {
    public static PropertyEnum<EnumDyeColor> COLOR = BlockColored.COLOR;
    private boolean useColorMultiplier = true;

    public ColorComponent(boolean useColorMultiplier) {
        this.useColorMultiplier = useColorMultiplier;
    }

    public boolean useColorMultiplier() {
        return this.useColorMultiplier;
    }

    public PropertyEnum<EnumDyeColor> getProperty() {
        return COLOR;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.withProperty(this.getProperty(), (Comparable)EnumDyeColor.WHITE);
    }

    @Override
    public void register(IComponentProvider block) {
        if (MalisisCore.isClient() && block instanceof Block) {
            this.registerColorHandler((Block)block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerColorHandler(Block block) {
        Minecraft.getMinecraft().getBlockColors().registerBlockColorHandler((IBlockColor)new ColorHandler(), new Block[]{block});
    }

    @Override
    public String getUnlocalizedName(Block block, IBlockState state) {
        return block.getUnlocalizedName() + "." + ColorComponent.getColor(state).getUnlocalizedName();
    }

    @Override
    public Item getItem(Block block) {
        return new MalisisItemBlock(block);
    }

    @Override
    public int damageDropped(Block block, IBlockState state) {
        return ((EnumDyeColor)state.getValue(this.getProperty())).getMetadata();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Block block, Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            list.add(new ItemStack(item, 1, color.getMetadata()));
        }
    }

    public int getRenderColor(Block block, IBlockState state) {
        return ItemDye.DYE_COLORS[ColorComponent.getColor(state).getDyeDamage()];
    }

    @Override
    public MapColor getMapColor(Block block, IBlockState state) {
        return ((EnumDyeColor)state.getValue(this.getProperty())).getMapColor();
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.withProperty(this.getProperty(), (Comparable)EnumDyeColor.byMetadata((int)meta));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return ((EnumDyeColor)state.getValue(this.getProperty())).getMetadata();
    }

    public static EnumDyeColor getColor(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? ColorComponent.getColor(world.getBlockState(pos)) : EnumDyeColor.WHITE;
    }

    public static EnumDyeColor getColor(IBlockState state) {
        ColorComponent cc = IComponent.getComponent(ColorComponent.class, state.getBlock());
        if (cc == null) {
            return EnumDyeColor.WHITE;
        }
        PropertyEnum<EnumDyeColor> property = cc.getProperty();
        if (property == null || !state.getProperties().containsKey(property)) {
            return EnumDyeColor.WHITE;
        }
        return (EnumDyeColor)state.getValue(property);
    }

    @SideOnly(value=Side.CLIENT)
    public class ColorHandler
    implements IBlockColor {
        public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
            if (!ColorComponent.this.useColorMultiplier) {
                return 0xFFFFFF;
            }
            return ColorComponent.this.getRenderColor(state.getBlock(), state);
        }
    }
}

