/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.base.Predicate;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DirectionalComponent
implements IBlockComponent {
    public static final PropertyDirection HORIZONTAL = PropertyDirection.create((String)"direction", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection ALL = PropertyDirection.create((String)"direction");
    private IPlacement placement = Placement.PLACER;
    private PropertyDirection property = HORIZONTAL;

    public DirectionalComponent(PropertyDirection property, IPlacement placement) {
        this.property = property;
        this.placement = placement;
    }

    public DirectionalComponent() {
        this(HORIZONTAL, Placement.PLACER);
    }

    public DirectionalComponent(PropertyDirection property) {
        this(property, Placement.PLACER);
    }

    public DirectionalComponent(IPlacement placement) {
        this(HORIZONTAL, placement);
    }

    public PropertyDirection getProperty() {
        return this.property;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.withProperty((IProperty)this.getProperty(), (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState placedState(IBlockState state, EnumFacing facing, EntityLivingBase placer) {
        return state.withProperty((IProperty)this.getProperty(), (Comparable)this.placement.getPlacement(state, facing, placer));
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.placedState(state, facing, placer);
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        EnumFacing facing = null;
        facing = this.getProperty() == HORIZONTAL ? EnumFacing.getHorizontal((int)(meta & 3)) : EnumFacing.getFront((int)(meta & 7));
        return state.withProperty((IProperty)this.getProperty(), (Comparable)facing);
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        if (this.getProperty() == HORIZONTAL) {
            return DirectionalComponent.getDirection(state).getHorizontalIndex();
        }
        return DirectionalComponent.getDirection(state).getIndex();
    }

    public static EnumFacing getDirection(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? DirectionalComponent.getDirection(world.getBlockState(pos)) : EnumFacing.SOUTH;
    }

    public static EnumFacing getDirection(IBlockState state) {
        DirectionalComponent dc = IComponent.getComponent(DirectionalComponent.class, state.getBlock());
        if (dc == null) {
            return EnumFacing.SOUTH;
        }
        PropertyDirection property = dc.getProperty();
        if (property == null || !state.getProperties().containsKey((Object)property)) {
            return EnumFacing.SOUTH;
        }
        return (EnumFacing)state.getValue((IProperty)property);
    }

    public static PropertyDirection getProperty(Block block) {
        DirectionalComponent dc = IComponent.getComponent(DirectionalComponent.class, block);
        return dc != null ? dc.getProperty() : null;
    }

    public static IBlockState rotate(IBlockState state) {
        return DirectionalComponent.rotate(state, 1);
    }

    public static IBlockState rotate(IBlockState state, int angle) {
        int a = -angle & 3;
        if (a == 0) {
            return state;
        }
        PropertyDirection property = DirectionalComponent.getProperty(state.getBlock());
        if (property == null || !state.getProperties().containsKey((Object)property)) {
            return state;
        }
        return state.withProperty((IProperty)property, (Comparable)EnumFacingUtils.rotateFacing((EnumFacing)state.getValue((IProperty)property), a));
    }

    public static IBlockState getPlacedState(IBlockState state, EnumFacing facing, EntityLivingBase placer) {
        DirectionalComponent dc = IComponent.getComponent(DirectionalComponent.class, state.getBlock());
        return dc != null ? dc.placedState(state, facing, placer) : state;
    }

    public static interface IPlacement {
        public EnumFacing getPlacement(IBlockState var1, EnumFacing var2, EntityLivingBase var3);
    }

    public static enum Placement implements IPlacement
    {
        BLOCKSIDE((state, side, placer) -> side),
        PLACER((state, side, placer) -> {
            EnumFacing facing = EntityUtils.getEntityFacing((Entity)placer, DirectionalComponent.getProperty(state.getBlock()) == ALL);
            return placer.isSneaking() ? facing : facing.getOpposite();
        });

        IPlacement placement;

        private Placement(IPlacement placement) {
            this.placement = placement;
        }

        @Override
        public EnumFacing getPlacement(IBlockState state, EnumFacing side, EntityLivingBase placer) {
            return this.placement.getPlacement(state, side, placer);
        }
    }
}

