/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LadderComponent
implements IBlockComponent {
    @Override
    public IProperty<?> getProperty() {
        return null;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state;
    }

    @Override
    public List<IComponent> getDependencies() {
        return Lists.newArrayList((Object[])new IComponent[]{new DirectionalComponent(DirectionalComponent.Placement.BLOCKSIDE)});
    }

    protected boolean canBlockStay(World world, BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos.offset(side.getOpposite()), side, true);
    }

    @Override
    public void onNeighborBlockChange(Block block, World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        EnumFacing dir = DirectionalComponent.getDirection((IBlockAccess)world, pos);
        if (!this.canBlockStay(world, pos, dir)) {
            block.dropBlockAsItem(world, pos, state, 0);
            world.setBlockToAir(pos);
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    }

    @Override
    public boolean canPlaceBlockOnSide(Block block, World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        return world.isSideSolid(pos.offset(side.getOpposite()), side, true);
    }

    @Override
    public boolean canPlaceBlockAt(Block block, World world, BlockPos pos) {
        return world.isSideSolid(pos.west(), EnumFacing.EAST, true) || world.isSideSolid(pos.east(), EnumFacing.WEST, true) || world.isSideSolid(pos.north(), EnumFacing.SOUTH, true) || world.isSideSolid(pos.south(), EnumFacing.NORTH, true);
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }
}

