/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.ISmartCull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PaneComponent
implements IBlockComponent,
ISmartCull {
    public static final PropertyBool NORTH = BlockPane.NORTH;
    public static final PropertyBool EAST = BlockPane.EAST;
    public static final PropertyBool SOUTH = BlockPane.SOUTH;
    public static final PropertyBool WEST = BlockPane.WEST;

    @Override
    public IProperty<?> getProperty() {
        return null;
    }

    @Override
    public IProperty<?>[] getProperties() {
        return new IProperty[]{NORTH, EAST, SOUTH, WEST};
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.withProperty((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)EAST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)WEST, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState getFullState(Block block, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() != block) {
            return block.getDefaultState();
        }
        return state.withProperty((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.NORTH))).withProperty((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.SOUTH))).withProperty((IProperty)WEST, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.WEST))).withProperty((IProperty)EAST, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.EAST)));
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        float f = 0.4375f;
        AxisAlignedBB base = new AxisAlignedBB((double)f, 0.0, (double)f, (double)(1.0f - f), 1.0, (double)(1.0f - f));
        state = world != null ? this.getFullState(block, world, pos) : block.getDefaultState();
        boolean north = (Boolean)state.getValue((IProperty)NORTH);
        boolean south = (Boolean)state.getValue((IProperty)SOUTH);
        boolean east = (Boolean)state.getValue((IProperty)EAST);
        boolean west = (Boolean)state.getValue((IProperty)WEST);
        if (world == null) {
            north = true;
            south = true;
        }
        if (!(north || south || east || west)) {
            north = true;
            south = true;
            east = true;
            west = true;
        }
        ArrayList list = Lists.newArrayList();
        if (north || south) {
            list.add(base.addCoord(0.0, 0.0, north ? (double)(-f) : 0.0).addCoord(0.0, 0.0, south ? (double)f : 0.0));
        }
        if (east || west) {
            list.add(base.addCoord(west ? (double)(-f) : 0.0, 0.0, 0.0).addCoord(east ? (double)f : 0.0, 0.0, 0.0));
        }
        return list.toArray(new AxisAlignedBB[0]);
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    public final boolean canPaneConnectToBlock(Block block, IBlockState state) {
        return block.isFullBlock(state) || block == Blocks.GLASS || block == Blocks.STAINED_GLASS || block == Blocks.STAINED_GLASS_PANE || block instanceof BlockPane;
    }

    public boolean canPaneConnectTo(Block block, IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos offset = pos.offset(dir);
        IBlockState state = world.getBlockState(offset);
        Block connected = state.getBlock();
        return connected == block || this.canPaneConnectToBlock(state.getBlock(), state) || connected.isSideSolid(state, world, offset, dir.getOpposite());
    }

    public static boolean isConnected(IBlockState state, PropertyBool property) {
        return (Boolean)state.getValue((IProperty)property);
    }
}

