/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import java.util.Random;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.ISmartCull;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.item.MalisisItemBlock;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SlabComponent
implements IBlockComponent,
IMergedBlock,
ISmartCull {
    private MalisisBlock singleSlab;
    private MalisisBlock doubleSlab;

    public SlabComponent(MalisisBlock singleSlab, MalisisBlock doubleSlab) {
        this.singleSlab = singleSlab;
        this.doubleSlab = doubleSlab;
        singleSlab.addComponent(this);
        doubleSlab.addComponent(this);
        doubleSlab.setName(singleSlab.getName() + "Double");
    }

    public boolean isDouble(Block block) {
        return block == this.doubleSlab;
    }

    public void register() {
        this.singleSlab.register();
        this.doubleSlab.register();
    }

    public PropertyEnum<BlockSlab.EnumBlockHalf> getProperty() {
        return BlockSlab.HALF;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.withProperty(this.getProperty(), (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
    }

    @Override
    public Item getItem(Block block) {
        if (this.isDouble(block)) {
            return null;
        }
        return new MalisisItemBlock(this.singleSlab);
    }

    @Override
    public boolean canMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        return world.getBlockState(pos).getBlock() == this.singleSlab;
    }

    @Override
    public IBlockState mergeBlock(World world, BlockPos pos, IBlockState state, ItemStack itemStack, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        int z;
        int y;
        int x = (int)Math.floor(hitX + (float)side.getFrontOffsetX() * 0.4f);
        BlockPos hitPos = new BlockPos((Vec3i)pos).add(x, y = (int)Math.floor(hitY + (float)side.getFrontOffsetY() * 0.4f), z = (int)Math.floor(hitZ + (float)side.getFrontOffsetZ() * 0.4f));
        return hitPos.equals((Object)pos) ? this.doubleSlab.getDefaultState() : null;
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.isDouble(block)) {
            return state;
        }
        return state.withProperty(this.getProperty(), (Comparable)(facing != EnumFacing.DOWN && (facing == EnumFacing.UP || hitY <= 0.5f) ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    @Override
    public AxisAlignedBB getBoundingBox(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (this.isDouble(block)) {
            return AABBUtils.identity();
        }
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        if (SlabComponent.isTop(state)) {
            aabb = aabb.offset(0.0, 0.5, 0.0);
        }
        return aabb;
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.withProperty(this.getProperty(), (Comparable)((meta & 8) != 0 ? BlockSlab.EnumBlockHalf.TOP : BlockSlab.EnumBlockHalf.BOTTOM));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return SlabComponent.isTop(state) ? 8 : 0;
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullBlock(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Integer getPackedLightmapCoords(Block block, IBlockAccess world, BlockPos pos, IBlockState state) {
        return null;
    }

    @Override
    public Item getItemDropped(Block block, IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this.singleSlab);
    }

    @Override
    public Integer quantityDropped(Block block, IBlockState state, int fortune, Random random) {
        return this.isDouble(block) ? 2 : 1;
    }

    @Override
    public Integer getLightOpacity(Block block, IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.isDouble(block) ? 255 : 0;
    }

    public static boolean isTop(IBlockAccess world, BlockPos pos) {
        return world != null ? SlabComponent.isTop(world.getBlockState(pos)) : false;
    }

    public static boolean isTop(IBlockState state) {
        SlabComponent sc = IComponent.getComponent(SlabComponent.class, state.getBlock());
        if (sc == null) {
            return false;
        }
        PropertyEnum<BlockSlab.EnumBlockHalf> property = sc.getProperty();
        if (property == null || !state.getProperties().containsKey(property)) {
            return false;
        }
        return state.getValue(property) == BlockSlab.EnumBlockHalf.TOP;
    }

    public static boolean isDoubleSlab(IBlockAccess world, BlockPos pos) {
        return SlabComponent.isDoubleSlab(world.getBlockState(pos).getBlock());
    }

    public static boolean isDoubleSlab(Block block) {
        SlabComponent sc = IComponent.getComponent(SlabComponent.class, block);
        return sc != null && sc.isDouble(block);
    }

    public static boolean isSlab(IBlockAccess world, BlockPos pos) {
        return SlabComponent.isSlab(world.getBlockState(pos).getBlock());
    }

    public static boolean isSlab(Block block) {
        if (block == Blocks.STONE_SLAB || block == Blocks.STONE_SLAB2 || block == Blocks.WOODEN_SLAB) {
            return true;
        }
        return IComponent.getComponent(SlabComponent.class, block) != null;
    }
}

