/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.component.SlopedCornerShapeComponent;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SlopedCornerComponent
implements IBlockComponent {
    public static PropertyBool INVERTED = PropertyBool.create((String)"inverted");
    public static PropertyBool DOWN = PropertyBool.create((String)"down");

    public PropertyBool getProperty() {
        return null;
    }

    @Override
    public IProperty<?>[] getProperties() {
        return new IProperty[]{INVERTED, DOWN};
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.withProperty((IProperty)INVERTED, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DOWN, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public List<IComponent> getDependencies() {
        ArrayList deps = Lists.newArrayList((Object[])new IComponent[]{new DirectionalComponent()});
        if (MalisisCore.isClient()) {
            deps.add(new SlopedCornerShapeComponent());
        }
        return deps;
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean down = facing == EnumFacing.DOWN || facing != EnumFacing.UP && hitY > 0.5f;
        return state.withProperty((IProperty)DOWN, (Comparable)Boolean.valueOf(down));
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        boolean inverted = SlopedCornerComponent.isInverted(state);
        boolean down = SlopedCornerComponent.isDown(state);
        float[][] fx = new float[][]{{0.0f, 1.0f}, {0.0f, 0.0f}};
        float[][] fy = new float[][]{{0.0f, 1.0f}, {0.0f, 1.0f}};
        float[][] fz = new float[][]{{0.0f, 1.0f}, {0.0f, 0.0f}};
        if (inverted) {
            if (down) {
                fx = new float[][]{{0.0f, 0.25f}, {0.0f, 1.0f}};
                fz = new float[][]{{0.0f, 0.25f}, {0.0f, 1.0f}};
            } else {
                fx = new float[][]{{0.0f, 1.0f}, {0.0f, 0.25f}};
                fz = new float[][]{{0.0f, 1.0f}, {0.0f, 0.25f}};
            }
        } else if (down) {
            fx = new float[][]{{0.0f, 0.125f}, {0.0f, 1.125f}};
            fz = new float[][]{{0.0f, 0.125f}, {0.0f, 1.125f}};
        }
        return AABBUtils.slice(8, fx, fy, fz, true);
    }

    @Override
    public void getSubBlocks(Block block, Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 4));
    }

    @Override
    public int damageDropped(Block block, IBlockState state) {
        return SlopedCornerComponent.isInverted(state) ? 1 : 0;
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return (SlopedCornerComponent.isInverted(state) ? 4 : 0) + (SlopedCornerComponent.isDown(state) ? 8 : 0);
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.withProperty((IProperty)DOWN, (Comparable)Boolean.valueOf((meta & 8) != 0)).withProperty((IProperty)INVERTED, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullBlock(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }

    public static boolean isDown(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? SlopedCornerComponent.isInverted(world.getBlockState(pos)) : false;
    }

    public static boolean isDown(IBlockState state) {
        SlopedCornerComponent sc = IComponent.getComponent(SlopedCornerComponent.class, state.getBlock());
        if (sc == null) {
            return false;
        }
        if (!state.getProperties().containsKey((Object)DOWN)) {
            return false;
        }
        return (Boolean)state.getValue((IProperty)DOWN);
    }

    public static boolean isInverted(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null ? SlopedCornerComponent.isInverted(world.getBlockState(pos)) : false;
    }

    public static boolean isInverted(IBlockState state) {
        SlopedCornerComponent sc = IComponent.getComponent(SlopedCornerComponent.class, state.getBlock());
        if (sc == null) {
            return false;
        }
        if (!state.getProperties().containsKey((Object)INVERTED)) {
            return false;
        }
        return (Boolean)state.getValue((IProperty)INVERTED);
    }
}

